// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  groups.vdl
package io.v.v23.services.groups;

/**
 * Wrapper for {@link GroupServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class GroupServerWrapper {
  private final io.v.v23.services.groups.GroupServer server;

  private final io.v.v23.services.groups.GroupReaderServerWrapper wrapperGroupReader;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  /**
   * Creates a new {@link GroupServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public GroupServerWrapper(io.v.v23.services.groups.GroupServer server) {
    this.server = server;

    this.wrapperGroupReader = new io.v.v23.services.groups.GroupReaderServerWrapper(server);

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.security.access.Permissions>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<
                          io.v.v23.services.groups.BlessingPatternChunk>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "create",
              "// Create creates a new group if it doesn't already exist."
                  + "// If perms is nil, a default Permissions is used, providing Admin access to"
                  + "// the caller."
                  + "// Create requires the caller to have Write permission at the GroupServer."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "delete",
              "// Delete deletes the group."
                  + "// Permissions for all group-related methods except Create() are checked"
                  + "// against the Group object."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.groups.BlessingPatternChunk.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "add", "// Add adds an entry to the group." + "", inArgs, outArgs, null, null, tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.groups.BlessingPatternChunk.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "remove",
              "// Remove removes an entry from the group." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Group",
        "io.v.v23.services.groups",
        "// A group's version covers its Permissions as well as any other data stored in"
            + "// the group. Clients should treat versions as opaque identifiers. For both Get"
            + "// and Relate, if version is set and matches the Group's current version, the"
            + "// response will indicate that fact but will otherwise be empty."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("add".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"add\": %s", e.getMessage()));
      }
    }

    if ("create".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
      }
    }

    if ("delete".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
      }
    }

    if ("remove".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"remove\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperGroupReader.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Create creates a new group if it doesn't already exist.
   * If perms is nil, a default Permissions is used, providing Admin access to
   * the caller.
   * Create requires the caller to have Write permission at the GroupServer.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.security.access.Permissions perms,
      final java.util.List<io.v.v23.services.groups.BlessingPatternChunk> entries) {

    return this.server.create(_ctx, _call, perms, entries);
  }

  /**
   * Delete deletes the group.
   * Permissions for all group-related methods except Create() are checked
   * against the Group object.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String version) {

    return this.server.delete(_ctx, _call, version);
  }

  /**
   * Add adds an entry to the group.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version) {

    return this.server.add(_ctx, _call, entry, version);
  }

  /**
   * Remove removes an entry from the group.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version) {

    return this.server.remove(_ctx, _call, entry, version);
  }

  /**
   * Get returns all entries in the group.
   * TODO(sadovsky): Flesh out this API.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderServer.GetOut>
      get(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion)
          throws io.v.v23.verror.VException {

    return this.wrapperGroupReader.get(ctx, call, req, reqVersion);
  }

  /**
   * Relate determines the relationships between the provided blessing
   * names and the members of the group.
   *<p>
   * Given an input set of blessing names and a group defined by a set of
   * blessing patterns S, for each blessing name B in the input, Relate(B)
   * returns a set of "remainders" consisting of every blessing name B"
   * such that there exists some B' for which B = B' B" and B' is in S,
   * and "" if B is a member of S.
   *<p>
   * For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then
   * Relate(n1:n2) = {n2, ""}.
   *<p>
   * reqVersion specifies the expected version of the group's membership
   * information. If this version is set and matches the Group's current
   * version, the response will indicate that fact but will otherwise be
   * empty.
   *<p>
   * visitedGroups is the set of groups already visited in a particular
   * chain of Relate calls, and is used to detect the presence of
   * cycles. When a cycle is detected, it is treated just like any other
   * error, and the result is approximated.
   *<p>
   * Relate also returns information about all the errors encountered that
   * resulted in approximations, if any.
   *<p>
   * TODO(hpucha): scrub "Approximation" for preserving privacy. Flesh
   * versioning out further. Other args we may need: option to Get() the
   * membership set when allowed (to avoid an extra RPC), options related
   * to caching this information.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderServer.RelateOut>
      relate(
          io.v.v23.context.VContext ctx,
          io.v.v23.rpc.StreamServerCall call,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups)
          throws io.v.v23.verror.VException {

    return this.wrapperGroupReader.relate(ctx, call, blessings, hint, reqVersion, visitedGroups);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }
}
