// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: groups.vdl
package io.v.v23.services.groups;

/**
 * A group's version covers its Permissions as well as any other data stored in
 * the group. Clients should treat versions as opaque identifiers. For both Get
 * and Relate, if version is set and matches the Group's current version, the
 * response will indicate that fact but will otherwise be empty.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.v23.services.groups.GroupServerWrapper.class)
public interface GroupServer
    extends io.v.v23.services.groups.GroupReaderServer, io.v.v23.services.permissions.ObjectServer {

  /**
   * Create creates a new group if it doesn't already exist.
   * If perms is nil, a default Permissions is used, providing Admin access to
   * the caller.
   * Create requires the caller to have Write permission at the GroupServer.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.util.List<io.v.v23.services.groups.BlessingPatternChunk> entries);

  /**
   * Delete deletes the group.
   * Permissions for all group-related methods except Create() are checked
   * against the Group object.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.lang.String version);

  /**
   * Add adds an entry to the group.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version);

  /**
   * Remove removes an entry from the group.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version);
}
