// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  groups.vdl
package io.v.v23.services.groups;

/**
 * Wrapper for {@link GroupReaderServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class GroupReaderServerWrapper {
  private final io.v.v23.services.groups.GroupReaderServer server;

  /**
   * Creates a new {@link GroupReaderServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public GroupReaderServerWrapper(io.v.v23.services.groups.GroupReaderServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.Set<java.lang.String>>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.groups.ApproximationType.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.Set<java.lang.String>>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.Set<java.lang.String>>() {}.getType())));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.services.groups.Approximation>>() {}.getType())));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Resolve"),
                  io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "relate",
              "// Relate determines the relationships between the provided blessing"
                  + "// names and the members of the group."
                  + "//"
                  + "// Given an input set of blessing names and a group defined by a set of"
                  + "// blessing patterns S, for each blessing name B in the input, Relate(B)"
                  + "// returns a set of \"remainders\" consisting of every blessing name B\""
                  + "// such that there exists some B' for which B = B' B\" and B' is in S,"
                  + "// and \"\" if B is a member of S."
                  + "//"
                  + "// For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then"
                  + "// Relate(n1:n2) = {n2, \"\"}."
                  + "//"
                  + "// reqVersion specifies the expected version of the group's membership"
                  + "// information. If this version is set and matches the Group's current"
                  + "// version, the response will indicate that fact but will otherwise be"
                  + "// empty."
                  + "//"
                  + "// visitedGroups is the set of groups already visited in a particular"
                  + "// chain of Relate calls, and is used to detect the presence of"
                  + "// cycles. When a cycle is detected, it is treated just like any other"
                  + "// error, and the result is approximated."
                  + "//"
                  + "// Relate also returns information about all the errors encountered that"
                  + "// resulted in approximations, if any."
                  + "//"
                  + "// TODO(hpucha): scrub \"Approximation\" for preserving privacy. Flesh"
                  + "// versioning out further. Other args we may need: option to Get() the"
                  + "// membership set when allowed (to avoid an extra RPC), options related"
                  + "// to caching this information."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.groups.GetRequest.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.groups.GetResponse.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "get",
              "// Get returns all entries in the group."
                  + "// TODO(sadovsky): Flesh out this API."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "GroupReader",
        "io.v.v23.services.groups",
        "// GroupReader implements methods to read or query a group's membership"
            + "// information."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("get".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"get\": %s", e.getMessage()));
      }
    }

    if ("relate".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Resolve"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"relate\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Relate determines the relationships between the provided blessing
   * names and the members of the group.
   *<p>
   * Given an input set of blessing names and a group defined by a set of
   * blessing patterns S, for each blessing name B in the input, Relate(B)
   * returns a set of "remainders" consisting of every blessing name B"
   * such that there exists some B' for which B = B' B" and B' is in S,
   * and "" if B is a member of S.
   *<p>
   * For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then
   * Relate(n1:n2) = {n2, ""}.
   *<p>
   * reqVersion specifies the expected version of the group's membership
   * information. If this version is set and matches the Group's current
   * version, the response will indicate that fact but will otherwise be
   * empty.
   *<p>
   * visitedGroups is the set of groups already visited in a particular
   * chain of Relate calls, and is used to detect the presence of
   * cycles. When a cycle is detected, it is treated just like any other
   * error, and the result is approximated.
   *<p>
   * Relate also returns information about all the errors encountered that
   * resulted in approximations, if any.
   *<p>
   * TODO(hpucha): scrub "Approximation" for preserving privacy. Flesh
   * versioning out further. Other args we may need: option to Get() the
   * membership set when allowed (to avoid an extra RPC), options related
   * to caching this information.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderServer.RelateOut>
      relate(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups) {

    return this.server.relate(_ctx, _call, blessings, hint, reqVersion, visitedGroups);
  }

  /**
   * Get returns all entries in the group.
   * TODO(sadovsky): Flesh out this API.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderServer.GetOut>
      get(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion) {

    return this.server.get(_ctx, _call, req, reqVersion);
  }
}
