// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: groups.vdl
package io.v.v23.services.groups;

/**
 * GroupReader implements methods to read or query a group's membership
 * information.
 */
public interface GroupReaderClient {

  /**
   * Multi-return value for method {@link #relate}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class RelateOut {

    public java.util.Set<java.lang.String> remainder;

    public java.util.List<io.v.v23.services.groups.Approximation> approximations;

    public java.lang.String version;
  }

  /**
   * Relate determines the relationships between the provided blessing
   * names and the members of the group.
   *<p>
   * Given an input set of blessing names and a group defined by a set of
   * blessing patterns S, for each blessing name B in the input, Relate(B)
   * returns a set of "remainders" consisting of every blessing name B"
   * such that there exists some B' for which B = B' B" and B' is in S,
   * and "" if B is a member of S.
   *<p>
   * For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then
   * Relate(n1:n2) = {n2, ""}.
   *<p>
   * reqVersion specifies the expected version of the group's membership
   * information. If this version is set and matches the Group's current
   * version, the response will indicate that fact but will otherwise be
   * empty.
   *<p>
   * visitedGroups is the set of groups already visited in a particular
   * chain of Relate calls, and is used to detect the presence of
   * cycles. When a cycle is detected, it is treated just like any other
   * error, and the result is approximated.
   *<p>
   * Relate also returns information about all the errors encountered that
   * resulted in approximations, if any.
   *<p>
   * TODO(hpucha): scrub "Approximation" for preserving privacy. Flesh
   * versioning out further. Other args we may need: option to Get() the
   * membership set when allowed (to avoid an extra RPC), options related
   * to caching this information.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.RelateOut>
      relate(
          io.v.v23.context.VContext context,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups);

  /**
   * Relate determines the relationships between the provided blessing
   * names and the members of the group.
   *<p>
   * Given an input set of blessing names and a group defined by a set of
   * blessing patterns S, for each blessing name B in the input, Relate(B)
   * returns a set of "remainders" consisting of every blessing name B"
   * such that there exists some B' for which B = B' B" and B' is in S,
   * and "" if B is a member of S.
   *<p>
   * For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then
   * Relate(n1:n2) = {n2, ""}.
   *<p>
   * reqVersion specifies the expected version of the group's membership
   * information. If this version is set and matches the Group's current
   * version, the response will indicate that fact but will otherwise be
   * empty.
   *<p>
   * visitedGroups is the set of groups already visited in a particular
   * chain of Relate calls, and is used to detect the presence of
   * cycles. When a cycle is detected, it is treated just like any other
   * error, and the result is approximated.
   *<p>
   * Relate also returns information about all the errors encountered that
   * resulted in approximations, if any.
   *<p>
   * TODO(hpucha): scrub "Approximation" for preserving privacy. Flesh
   * versioning out further. Other args we may need: option to Get() the
   * membership set when allowed (to avoid an extra RPC), options related
   * to caching this information.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.RelateOut>
      relate(
          io.v.v23.context.VContext context,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups,
          io.v.v23.Options opts);

  /**
   * Relate determines the relationships between the provided blessing
   * names and the members of the group.
   *<p>
   * Given an input set of blessing names and a group defined by a set of
   * blessing patterns S, for each blessing name B in the input, Relate(B)
   * returns a set of "remainders" consisting of every blessing name B"
   * such that there exists some B' for which B = B' B" and B' is in S,
   * and "" if B is a member of S.
   *<p>
   * For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then
   * Relate(n1:n2) = {n2, ""}.
   *<p>
   * reqVersion specifies the expected version of the group's membership
   * information. If this version is set and matches the Group's current
   * version, the response will indicate that fact but will otherwise be
   * empty.
   *<p>
   * visitedGroups is the set of groups already visited in a particular
   * chain of Relate calls, and is used to detect the presence of
   * cycles. When a cycle is detected, it is treated just like any other
   * error, and the result is approximated.
   *<p>
   * Relate also returns information about all the errors encountered that
   * resulted in approximations, if any.
   *<p>
   * TODO(hpucha): scrub "Approximation" for preserving privacy. Flesh
   * versioning out further. Other args we may need: option to Get() the
   * membership set when allowed (to avoid an extra RPC), options related
   * to caching this information.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.RelateOut>
      relate(
          io.v.v23.context.VContext context,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups,
          io.v.v23.options.RpcOptions opts);

  /**
   * Multi-return value for method {@link #get}.
   */
  @io.v.v23.vdl.MultiReturn
  public static class GetOut {

    public io.v.v23.services.groups.GetResponse res;

    public java.lang.String version;
  }

  /**
   * Get returns all entries in the group.
   * TODO(sadovsky): Flesh out this API.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.GetOut>
      get(
          io.v.v23.context.VContext context,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion);

  /**
   * Get returns all entries in the group.
   * TODO(sadovsky): Flesh out this API.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.GetOut>
      get(
          io.v.v23.context.VContext context,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion,
          io.v.v23.Options opts);

  /**
   * Get returns all entries in the group.
   * TODO(sadovsky): Flesh out this API.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.GetOut>
      get(
          io.v.v23.context.VContext context,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion,
          io.v.v23.options.RpcOptions opts);
}
