// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  groups.vdl
package io.v.v23.services.groups;

/**
 * Implementation of the {@link GroupClient} interface.
 */
final class GroupClientImpl implements io.v.v23.services.groups.GroupClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.groups.GroupReaderClient implGroupReader;

  private final io.v.v23.services.permissions.ObjectClient implObject;

  /**
   * Creates a new instance of {@link GroupClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public GroupClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implGroupReader =
          io.v.v23.services.groups.GroupReaderClientFactory.getGroupReaderClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implObject =
          io.v.v23.services.permissions.ObjectClientFactory.getObjectClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface GroupClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.util.List<io.v.v23.services.groups.BlessingPatternChunk> entries) {
    return create(_context, perms, entries, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      final io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.util.List<io.v.v23.services.groups.BlessingPatternChunk> entries,
      io.v.v23.Options _opts) {
    return create(_context, perms, entries, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> create(
      final io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.util.List<io.v.v23.services.groups.BlessingPatternChunk> entries,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {perms, entries};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<
              io.v.v23.security.access.Permissions>() {}.getType(),
          new com.google.common.reflect.TypeToken<
              java.util.List<io.v.v23.services.groups.BlessingPatternChunk>>() {}.getType()
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "create", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _context, final java.lang.String version) {
    return delete(_context, version, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      final io.v.v23.context.VContext _context,
      final java.lang.String version,
      io.v.v23.Options _opts) {
    return delete(_context, version, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      final io.v.v23.context.VContext _context,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {version};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {java.lang.String.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "delete", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version) {
    return add(_context, entry, version, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version,
      io.v.v23.Options _opts) {
    return add(_context, entry, version, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> add(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {entry, version};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.groups.BlessingPatternChunk.class, java.lang.String.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "add", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      io.v.v23.context.VContext _context,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version) {
    return remove(_context, entry, version, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version,
      io.v.v23.Options _opts) {
    return remove(_context, entry, version, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> remove(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.groups.BlessingPatternChunk entry,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {entry, version};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          io.v.v23.services.groups.BlessingPatternChunk.class, java.lang.String.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "remove", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.GetOut>
      get(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion) {

    return this.implGroupReader.get(_context, req, reqVersion);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.GetOut>
      get(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion,
          io.v.v23.Options _opts) {

    return this.implGroupReader.get(_context, req, reqVersion, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.GetOut>
      get(
          io.v.v23.context.VContext _context,
          final io.v.v23.services.groups.GetRequest req,
          final java.lang.String reqVersion,
          io.v.v23.options.RpcOptions _opts) {

    return this.implGroupReader.get(_context, req, reqVersion, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.RelateOut>
      relate(
          io.v.v23.context.VContext _context,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups) {

    return this.implGroupReader.relate(_context, blessings, hint, reqVersion, visitedGroups);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.RelateOut>
      relate(
          io.v.v23.context.VContext _context,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups,
          io.v.v23.Options _opts) {

    return this.implGroupReader.relate(_context, blessings, hint, reqVersion, visitedGroups, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.groups.GroupReaderClient.RelateOut>
      relate(
          io.v.v23.context.VContext _context,
          final java.util.Set<java.lang.String> blessings,
          final io.v.v23.services.groups.ApproximationType hint,
          final java.lang.String reqVersion,
          final java.util.Set<java.lang.String> visitedGroups,
          io.v.v23.options.RpcOptions _opts) {

    return this.implGroupReader.relate(_context, blessings, hint, reqVersion, visitedGroups, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context) {

    return this.implObject.getPermissions(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.implObject.setPermissions(_context, perms, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }
}
