// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  device.vdl
package io.v.v23.services.device;

/**
 * Wrapper for {@link DeviceServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class DeviceServerWrapper {
  private final io.v.v23.services.device.DeviceServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  private final io.v.v23.services.device.ApplicationServerWrapper wrapperApplication;

  private final io.v.v23.services.tidyable.TidyableServerWrapper wrapperTidyable;

  /**
   * Creates a new {@link DeviceServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public DeviceServerWrapper(io.v.v23.services.device.DeviceServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);

    this.wrapperApplication = new io.v.v23.services.device.ApplicationServerWrapper(server);

    this.wrapperTidyable = new io.v.v23.services.tidyable.TidyableServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.device.Description.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "describe",
              "// Describe generates a description of the device." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.binary.Description.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "isRunnable",
              "// IsRunnable checks if the device can execute the given binary." + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(org.joda.time.Duration.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "reset",
              "// Reset resets the device. If the deadline is non-zero and the device"
                  + "// in question is still running after the given deadline expired,"
                  + "// reset of the device is enforced."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<java.lang.String>>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "associateAccount",
              "// AssociateAccount associates a local  system account name with the provided"
                  + "// Vanadium identities. It replaces the existing association if one already exists for that"
                  + "// identity. Setting an AccountName to \"\" removes the association for each"
                  + "// listed identity."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      java.util.List<io.v.v23.services.device.Association>>() {}.getType())));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "listAssociations",
              "// ListAssociations returns all of the associations between Vanadium identities"
                  + "// and system names."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Device",
        "io.v.v23.services.device",
        "// Device can be used to manage a device remotely using an object name that"
            + "// identifies it."
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("associateAccount".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"associateAccount\": %s", e.getMessage()));
      }
    }

    if ("describe".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"describe\": %s", e.getMessage()));
      }
    }

    if ("isRunnable".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"isRunnable\": %s", e.getMessage()));
      }
    }

    if ("listAssociations".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"listAssociations\": %s", e.getMessage()));
      }
    }

    if ("reset".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"reset\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperApplication.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperTidyable.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Describe generates a description of the device.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description>
      describe(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.describe(_ctx, _call);
  }

  /**
   * IsRunnable checks if the device can execute the given binary.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final io.v.v23.services.binary.Description description) {

    return this.server.isRunnable(_ctx, _call, description);
  }

  /**
   * Reset resets the device. If the deadline is non-zero and the device
   * in question is still running after the given deadline expired,
   * reset of the device is enforced.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final org.joda.time.Duration deadline) {

    return this.server.reset(_ctx, _call, deadline);
  }

  /**
   * AssociateAccount associates a local  system account name with the provided
   * Vanadium identities. It replaces the existing association if one already exists for that
   * identity. Setting an AccountName to "" removes the association for each
   * listed identity.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName) {

    return this.server.associateAccount(_ctx, _call, identityNames, accountName);
  }

  /**
   * ListAssociations returns all of the associations between Vanadium identities
   * and system names.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.listAssociations(_ctx, _call);
  }

  /**
   * Debug returns debug information about the application installation or
   * instance.  This is generally highly implementation-specific, and
   * presented in an unstructured form.  No guarantees are given about the
   * stability of the format, and parsing it programmatically is
   * specifically discouraged.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> debug(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.debug(ctx, call);
  }

  /**
   * Delete deletes an instance.  Once deleted, the instance cannot be
   * revived.
   * The instance must be in state NotRunning.
   *<p>
   * If called against a Device, causes the Device to shut itself down.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.delete(ctx, call);
  }

  /**
   * Install installs the application identified by the first argument and
   * returns an object name suffix that identifies the new installation.
   *<p>
   * The name argument should be an object name for an application
   * envelope.  The service it identifies must implement
   * repository.Application, and is expected to return either the
   * requested version (if the object name encodes a specific version), or
   * otherwise the latest available version, as appropriate.  This object
   * name will be used by default by the Update method, as a source for
   * updated application envelopes (can be overriden by setting
   * AppOriginConfigKey in the config).
   *<p>
   * The config argument specifies config settings that will take
   * precedence over those present in the application envelope.
   *<p>
   * The packages argument specifies packages to be installed in addition
   * to those specified in the envelope.  If a package in the envelope has
   * the same key, the package in the packages argument takes precedence.
   *<p>
   * The returned suffix, when appended to the name used to reach the
   * receiver for Install, can be used to control the installation object.
   * The suffix will contain the title of the application as a prefix,
   * which can then be used to control all the installations of the given
   * application.
   * TODO(rjkroege): Use customized labels.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> install(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final java.lang.String name,
      final io.v.v23.services.device.Config config,
      final io.v.v23.services.application.Packages packages)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.install(ctx, call, name, config, packages);
  }

  /**
   * Instantiate creates an instance of an application installation.
   * The installation must be in state Active.
   *<p>
   * The server sends the application instance's Public Key on the stream.
   * When the client receives the Public Key it must send Blessings back
   * to the server. When the instance is created, the server returns the
   * instance name to the client.
   *<p>
   * Client                       Server
   *  "object".Instantiate() -->
   *                         <--  InstancePublicKey
   *  AppBlessings           -->
   *                         <--  return InstanceName
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> instantiate(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.instantiate(ctx, call);
  }

  /**
   * Kill attempts a clean shutdown an of application instance.
   * The instance must be in state Running.
   *<p>
   * If the deadline is non-zero and the instance in question is still
   * running after the given deadline, shutdown of the instance is
   * enforced.
   *<p>
   * If called against a Device, causes the Device to stop itself (which
   * may or may not result in a restart depending on the device manager
   * setup).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> kill(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final org.joda.time.Duration deadline)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.kill(ctx, call, deadline);
  }

  /**
   * Revert reverts an application installation's version to the previous
   * version of its current version.  The installation must be in state
   * Active.
   *<p>
   * Revert reverts an application instance's version to the previous
   * version of its current version.  The instance must be in state
   * NotRunning.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> revert(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.revert(ctx, call);
  }

  /**
   * Run begins execution of an application instance.
   * The instance must be in state NotRunning.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> run(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.run(ctx, call);
  }

  /**
   * Status returns structured information about the application
   * installation or instance.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Status> status(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.status(ctx, call);
  }

  /**
   * Uninstall uninstalls an application installation.
   * The installation must be in state Active.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> uninstall(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.uninstall(ctx, call);
  }

  /**
   * Update updates an application installation's version to a new version
   * created from the envelope at the object name provided during Install.
   * If the new application envelope contains a different application
   * title, the update does not occur, and an error is returned.  The
   * installation must be in state Active.
   *<p>
   * Update updates an application instance's version to the current
   * installation version.  The instance must be in state NotRunning.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> update(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.update(ctx, call);
  }

  /**
   * UpdateTo updates the application installation(s) to the application
   * specified by the object name argument.  If the new application
   * envelope contains a different application title, the update does not
   * occur, and an error is returned.
   * The installation must be in state Active.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> updateTo(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final java.lang.String name)
      throws io.v.v23.verror.VException {

    return this.wrapperApplication.updateTo(ctx, call, name);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }

  /**
   * Request the implementing service to perform regularly scheduled cleanup
   *  actions such as shrinking caches or rolling logs immediately.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
      throws io.v.v23.verror.VException {

    return this.wrapperTidyable.tidyNow(ctx, call);
  }
}
