// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: device.vdl
package io.v.v23.services.device;

/**
 * Device can be used to manage a device remotely using an object name that
 * identifies it.
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.v23.services.device.DeviceServerWrapper.class)
public interface DeviceServer
    extends io.v.v23.services.device.ApplicationServer, io.v.v23.services.tidyable.TidyableServer {

  /**
   * Describe generates a description of the device.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description> describe(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * IsRunnable checks if the device can execute the given binary.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final io.v.v23.services.binary.Description description);

  /**
   * Reset resets the device. If the deadline is non-zero and the device
   * in question is still running after the given deadline expired,
   * reset of the device is enforced.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final org.joda.time.Duration deadline);

  /**
   * AssociateAccount associates a local  system account name with the provided
   * Vanadium identities. It replaces the existing association if one already exists for that
   * identity. Setting an AccountName to "" removes the association for each
   * listed identity.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName);

  /**
   * ListAssociations returns all of the associations between Vanadium identities
   * and system names.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);
}
