// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  device.vdl
package io.v.v23.services.device;

/**
 * Implementation of the {@link DeviceClient} interface.
 */
final class DeviceClientImpl implements io.v.v23.services.device.DeviceClient {
  private final io.v.v23.rpc.Client client;
  private final java.lang.String vName;

  private final io.v.v23.services.permissions.ObjectClient implObject;

  private final io.v.v23.services.device.ApplicationClient implApplication;

  private final io.v.v23.services.tidyable.TidyableClient implTidyable;

  /**
   * Creates a new instance of {@link DeviceClientImpl}.
   *
   * @param client Vanadium client
   * @param vName  remote server name
   */
  public DeviceClientImpl(io.v.v23.rpc.Client client, java.lang.String vName) {
    this.client = client;
    this.vName = vName;

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implObject =
          io.v.v23.services.permissions.ObjectClientFactory.getObjectClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implApplication =
          io.v.v23.services.device.ApplicationClientFactory.getApplicationClient(vName, opts);
    }

    {
      io.v.v23.Options opts = new io.v.v23.Options();
      opts.set(io.v.v23.OptionDefs.CLIENT, client);
      this.implTidyable =
          io.v.v23.services.tidyable.TidyableClientFactory.getTidyableClient(vName, opts);
    }
  }

  private io.v.v23.rpc.Client getClient(io.v.v23.context.VContext context) {
    return this.client != null ? client : io.v.v23.V.getClient(context);
  }

  // Methods from interface DeviceClient.

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description>
      describe(io.v.v23.context.VContext _context) {
    return describe(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description>
      describe(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return describe(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description>
      describe(final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "describe", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, io.v.v23.services.device.Description>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.device.Description>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      io.v.v23.services.device.Description.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], io.v.v23.services.device.Description>() {
                      @Override
                      public io.v.v23.services.device.Description apply(Object[] _results) {

                        return (io.v.v23.services.device.Description) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      io.v.v23.context.VContext _context, final io.v.v23.services.binary.Description description) {
    return isRunnable(_context, description, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.binary.Description description,
      io.v.v23.Options _opts) {
    return isRunnable(_context, description, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      final io.v.v23.context.VContext _context,
      final io.v.v23.services.binary.Description description,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {description};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {io.v.v23.services.binary.Description.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "isRunnable", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Boolean>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      java.lang.Boolean.class,
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Boolean>() {
                      @Override
                      public java.lang.Boolean apply(Object[] _results) {

                        return (java.lang.Boolean) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      io.v.v23.context.VContext _context, final org.joda.time.Duration deadline) {
    return reset(_context, deadline, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      final io.v.v23.context.VContext _context,
      final org.joda.time.Duration deadline,
      io.v.v23.Options _opts) {
    return reset(_context, deadline, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      final io.v.v23.context.VContext _context,
      final org.joda.time.Duration deadline,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {deadline};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {org.joda.time.Duration.class};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context).startCall(_context, this.vName, "reset", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      io.v.v23.context.VContext _context,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName) {
    return associateAccount(
        _context, identityNames, accountName, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      final io.v.v23.context.VContext _context,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName,
      io.v.v23.Options _opts) {
    return associateAccount(
        _context, identityNames, accountName, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      final io.v.v23.context.VContext _context,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName,
      io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {identityNames, accountName};
    java.lang.reflect.Type[] _argTypes =
        new java.lang.reflect.Type[] {
          new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {}.getType(),
          java.lang.String.class
        };
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "associateAccount", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.lang.Void>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> apply(
                  final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes = new java.lang.reflect.Type[] {};

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<Object[], java.lang.Void>() {
                      @Override
                      public java.lang.Void apply(Object[] _results) {

                        return null;
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(io.v.v23.context.VContext _context) {
    return listAssociations(_context, (io.v.v23.options.RpcOptions) null);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(final io.v.v23.context.VContext _context, io.v.v23.Options _opts) {
    return listAssociations(_context, io.v.v23.options.RpcOptions.migrateOptions(_opts));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(
          final io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    // Start the call.
    java.lang.Object[] _args = new java.lang.Object[] {};
    java.lang.reflect.Type[] _argTypes = new java.lang.reflect.Type[] {};
    final com.google.common.util.concurrent.ListenableFuture<io.v.v23.rpc.ClientCall> _callFuture =
        getClient(_context)
            .startCall(_context, this.vName, "listAssociations", _args, _argTypes, _opts);

    return io.v.v23.VFutures.withUserLandChecks(
        _context,
        com.google.common.util.concurrent.Futures.transform(
            _callFuture,
            new com.google.common.util.concurrent.AsyncFunction<
                io.v.v23.rpc.ClientCall, java.util.List<io.v.v23.services.device.Association>>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      java.util.List<io.v.v23.services.device.Association>>
                  apply(final io.v.v23.rpc.ClientCall _call) throws Exception {

                java.lang.reflect.Type[] _resultTypes =
                    new java.lang.reflect.Type[] {
                      new com.google.common.reflect.TypeToken<
                          java.util.List<io.v.v23.services.device.Association>>() {}.getType(),
                    };

                // Finish the call.
                return com.google.common.util.concurrent.Futures.transform(
                    _call.finish(_resultTypes),
                    new com.google.common.base.Function<
                        Object[], java.util.List<io.v.v23.services.device.Association>>() {
                      @Override
                      public java.util.List<io.v.v23.services.device.Association> apply(
                          Object[] _results) {

                        return (java.util.List<io.v.v23.services.device.Association>) _results[0];
                      }
                    });
              }
            }));
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> debug(
      io.v.v23.context.VContext _context) {

    return this.implApplication.debug(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> debug(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.debug(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> debug(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.debug(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _context) {

    return this.implApplication.delete(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.delete(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.delete(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> install(
      io.v.v23.context.VContext _context,
      final java.lang.String name,
      final io.v.v23.services.device.Config config,
      final io.v.v23.services.application.Packages packages) {

    return this.implApplication.install(_context, name, config, packages);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> install(
      io.v.v23.context.VContext _context,
      final java.lang.String name,
      final io.v.v23.services.device.Config config,
      final io.v.v23.services.application.Packages packages,
      io.v.v23.Options _opts) {

    return this.implApplication.install(_context, name, config, packages, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> install(
      io.v.v23.context.VContext _context,
      final java.lang.String name,
      final io.v.v23.services.device.Config config,
      final io.v.v23.services.application.Packages packages,
      io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.install(_context, name, config, packages, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.v23.services.device.BlessClientMessage, io.v.v23.services.device.BlessServerMessage,
          java.lang.String>
      instantiate(io.v.v23.context.VContext _context) {

    return this.implApplication.instantiate(_context);
  }

  @Deprecated
  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.v23.services.device.BlessClientMessage, io.v.v23.services.device.BlessServerMessage,
          java.lang.String>
      instantiate(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.instantiate(_context, _opts);
  }

  @Override
  public io.v.v23.vdl.ClientStream<
          io.v.v23.services.device.BlessClientMessage, io.v.v23.services.device.BlessServerMessage,
          java.lang.String>
      instantiate(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.instantiate(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> kill(
      io.v.v23.context.VContext _context, final org.joda.time.Duration deadline) {

    return this.implApplication.kill(_context, deadline);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> kill(
      io.v.v23.context.VContext _context,
      final org.joda.time.Duration deadline,
      io.v.v23.Options _opts) {

    return this.implApplication.kill(_context, deadline, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> kill(
      io.v.v23.context.VContext _context,
      final org.joda.time.Duration deadline,
      io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.kill(_context, deadline, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> revert(
      io.v.v23.context.VContext _context) {

    return this.implApplication.revert(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> revert(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.revert(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> revert(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.revert(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> run(
      io.v.v23.context.VContext _context) {

    return this.implApplication.run(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> run(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.run(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> run(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.run(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Status> status(
      io.v.v23.context.VContext _context) {

    return this.implApplication.status(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Status> status(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.status(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Status> status(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.status(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> uninstall(
      io.v.v23.context.VContext _context) {

    return this.implApplication.uninstall(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> uninstall(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.uninstall(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> uninstall(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.uninstall(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> update(
      io.v.v23.context.VContext _context) {

    return this.implApplication.update(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> update(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implApplication.update(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> update(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.update(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> updateTo(
      io.v.v23.context.VContext _context, final java.lang.String name) {

    return this.implApplication.updateTo(_context, name);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> updateTo(
      io.v.v23.context.VContext _context, final java.lang.String name, io.v.v23.Options _opts) {

    return this.implApplication.updateTo(_context, name, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> updateTo(
      io.v.v23.context.VContext _context,
      final java.lang.String name,
      io.v.v23.options.RpcOptions _opts) {

    return this.implApplication.updateTo(_context, name, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context) {

    return this.implObject.getPermissions(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectClient.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implObject.getPermissions(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version) {

    return this.implObject.setPermissions(_context, perms, version);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.Options _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext _context,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version,
      io.v.v23.options.RpcOptions _opts) {

    return this.implObject.setPermissions(_context, perms, version, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext _context) {

    return this.implTidyable.tidyNow(_context);
  }

  @Deprecated
  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext _context, io.v.v23.Options _opts) {

    return this.implTidyable.tidyNow(_context, _opts);
  }

  @Override
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> tidyNow(
      io.v.v23.context.VContext _context, io.v.v23.options.RpcOptions _opts) {

    return this.implTidyable.tidyNow(_context, _opts);
  }
}
