// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: device.vdl
package io.v.v23.services.device;

/**
 * Device can be used to manage a device remotely using an object name that
 * identifies it.
 */
public interface DeviceClient
    extends io.v.v23.services.device.ApplicationClient, io.v.v23.services.tidyable.TidyableClient {

  /**
   * Describe generates a description of the device.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description> describe(
      io.v.v23.context.VContext context);

  /**
   * Describe generates a description of the device.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description> describe(
      io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * Describe generates a description of the device.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Description> describe(
      io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);

  /**
   * IsRunnable checks if the device can execute the given binary.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      io.v.v23.context.VContext context, final io.v.v23.services.binary.Description description);

  /**
   * IsRunnable checks if the device can execute the given binary.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      io.v.v23.context.VContext context,
      final io.v.v23.services.binary.Description description,
      io.v.v23.Options opts);

  /**
   * IsRunnable checks if the device can execute the given binary.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Boolean> isRunnable(
      io.v.v23.context.VContext context,
      final io.v.v23.services.binary.Description description,
      io.v.v23.options.RpcOptions opts);

  /**
   * Reset resets the device. If the deadline is non-zero and the device
   * in question is still running after the given deadline expired,
   * reset of the device is enforced.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      io.v.v23.context.VContext context, final org.joda.time.Duration deadline);

  /**
   * Reset resets the device. If the deadline is non-zero and the device
   * in question is still running after the given deadline expired,
   * reset of the device is enforced.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      io.v.v23.context.VContext context,
      final org.joda.time.Duration deadline,
      io.v.v23.Options opts);

  /**
   * Reset resets the device. If the deadline is non-zero and the device
   * in question is still running after the given deadline expired,
   * reset of the device is enforced.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> reset(
      io.v.v23.context.VContext context,
      final org.joda.time.Duration deadline,
      io.v.v23.options.RpcOptions opts);

  /**
   * AssociateAccount associates a local  system account name with the provided
   * Vanadium identities. It replaces the existing association if one already exists for that
   * identity. Setting an AccountName to "" removes the association for each
   * listed identity.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      io.v.v23.context.VContext context,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName);

  /**
   * AssociateAccount associates a local  system account name with the provided
   * Vanadium identities. It replaces the existing association if one already exists for that
   * identity. Setting an AccountName to "" removes the association for each
   * listed identity.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      io.v.v23.context.VContext context,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName,
      io.v.v23.Options opts);

  /**
   * AssociateAccount associates a local  system account name with the provided
   * Vanadium identities. It replaces the existing association if one already exists for that
   * identity. Setting an AccountName to "" removes the association for each
   * listed identity.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> associateAccount(
      io.v.v23.context.VContext context,
      final java.util.List<java.lang.String> identityNames,
      final java.lang.String accountName,
      io.v.v23.options.RpcOptions opts);

  /**
   * ListAssociations returns all of the associations between Vanadium identities
   * and system names.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(io.v.v23.context.VContext context);

  /**
   * ListAssociations returns all of the associations between Vanadium identities
   * and system names.
   */
  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(io.v.v23.context.VContext context, io.v.v23.Options opts);

  /**
   * ListAssociations returns all of the associations between Vanadium identities
   * and system names.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<
          java.util.List<io.v.v23.services.device.Association>>
      listAssociations(io.v.v23.context.VContext context, io.v.v23.options.RpcOptions opts);
}
