// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: device.vdl
package io.v.v23.services.device;

/**
 * Description enumerates the profiles that a Device supports.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/device.Description")
public class Description extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Profiles", index = 0)
  private java.util.Set<java.lang.String> profiles;

  /**
   * Vdl type for {@link Description}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Description.class);

  /**
   * Creates a new zero-value instance of {@link Description}.
   */
  public Description() {
    super(VDL_TYPE);

    this.profiles = new java.util.HashSet<java.lang.String>();
  }

  /**
   * Creates a new instance of {@link Description} with the provided field values.
   */
  public Description(java.util.Set<java.lang.String> profiles) {
    super(VDL_TYPE);

    this.profiles = profiles;
  }

  /**
   * Profiles is a set of names of supported profiles.	Each name can
   * either be an object name that resolves to a Profile, or can be the
   * profile's label, e.g.:
   *   "profiles/google/cluster/diskfull"
   *   "linux-media"
   *<p>
   * Profiles for devices can be provided by hand, but they can also be
   * automatically derived by examining the device.
   */
  public java.util.Set<java.lang.String> getProfiles() {
    return this.profiles;
  }

  /**
   * Profiles is a set of names of supported profiles.	Each name can
   * either be an object name that resolves to a Profile, or can be the
   * profile's label, e.g.:
   *   "profiles/google/cluster/diskfull"
   *   "linux-media"
   *<p>
   * Profiles for devices can be provided by hand, but they can also be
   * automatically derived by examining the device.
   */
  public void setProfiles(java.util.Set<java.lang.String> profiles) {
    this.profiles = profiles;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Description other = (Description) obj;

    if (this.profiles == null) {
      if (other.profiles != null) {
        return false;
      }
    } else if (!this.profiles.equals(other.profiles)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.profiles == null ? 0 : this.profiles.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "profiles:" + this.profiles;

    return result + "}";
  }
}
