// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: device.vdl
package io.v.v23.services.device;

/**
 * Claimable represents an uninitialized device with no owner
 * (i.e., a device that has no blessings).
 *<p>
 * Claim is used to claim ownership by blessing the device's private key.
 * Devices that have provided a pairing token to the claimer through an
 * out-of-band communication channel (eg: display/email) would expect this
 * pairing token to be replayed by the claimer.
 *<p>
 * Once claimed, the device will export the "Device" interface and all methods
 * will be restricted to the claimer.
 *<p>
 * The blessings that the device is to be claimed with is provided
 * via the ipc.Granter option in Go.
 */
public interface ClaimableClient {

  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> claim(
      io.v.v23.context.VContext context, final java.lang.String pairingToken);

  @javax.annotation.CheckReturnValue
  @java.lang.Deprecated
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> claim(
      io.v.v23.context.VContext context,
      final java.lang.String pairingToken,
      io.v.v23.Options opts);

  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> claim(
      io.v.v23.context.VContext context,
      final java.lang.String pairingToken,
      io.v.v23.options.RpcOptions opts);
}
