// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  device.vdl
package io.v.v23.services.device;

/**
 * Wrapper for {@link ApplicationServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class ApplicationServerWrapper {
  private final io.v.v23.services.device.ApplicationServer server;

  private final io.v.v23.services.permissions.ObjectServerWrapper wrapperObject;

  /**
   * Creates a new {@link ApplicationServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public ApplicationServerWrapper(io.v.v23.services.device.ApplicationServer server) {
    this.server = server;

    this.wrapperObject = new io.v.v23.services.permissions.ObjectServerWrapper(server);
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.services.device.Config>() {}.getType())));

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "",
              "",
              new io.v.v23.vdl.VdlTypeObject(
                  new com.google.common.reflect.TypeToken<
                      io.v.v23.services.application.Packages>() {}.getType())));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "install",
              "// Install installs the application identified by the first argument and"
                  + "// returns an object name suffix that identifies the new installation."
                  + "//"
                  + "// The name argument should be an object name for an application"
                  + "// envelope.  The service it identifies must implement"
                  + "// repository.Application, and is expected to return either the"
                  + "// requested version (if the object name encodes a specific version), or"
                  + "// otherwise the latest available version, as appropriate.  This object"
                  + "// name will be used by default by the Update method, as a source for"
                  + "// updated application envelopes (can be overriden by setting"
                  + "// AppOriginConfigKey in the config)."
                  + "//"
                  + "// The config argument specifies config settings that will take"
                  + "// precedence over those present in the application envelope."
                  + "//"
                  + "// The packages argument specifies packages to be installed in addition"
                  + "// to those specified in the envelope.  If a package in the envelope has"
                  + "// the same key, the package in the packages argument takes precedence."
                  + "//"
                  + "// The returned suffix, when appended to the name used to reach the"
                  + "// receiver for Install, can be used to control the installation object."
                  + "// The suffix will contain the title of the application as a prefix,"
                  + "// which can then be used to control all the installations of the given"
                  + "// application."
                  + "// TODO(rjkroege): Use customized labels."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "uninstall",
              "// Uninstall uninstalls an application installation."
                  + "// The installation must be in state Active."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "instantiate",
              "// Instantiate creates an instance of an application installation."
                  + "// The installation must be in state Active."
                  + "//"
                  + "// The server sends the application instance's Public Key on the stream."
                  + "// When the client receives the Public Key it must send Blessings back"
                  + "// to the server. When the instance is created, the server returns the"
                  + "// instance name to the client."
                  + "//"
                  + "// Client                       Server"
                  + "//  \"object\".Instantiate() -->"
                  + "//                         <--  InstancePublicKey"
                  + "//  AppBlessings           -->"
                  + "//                         <--  return InstanceName"
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "delete",
              "// Delete deletes an instance.  Once deleted, the instance cannot be"
                  + "// revived."
                  + "// The instance must be in state NotRunning."
                  + "//"
                  + "// If called against a Device, causes the Device to shut itself down."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "run",
              "// Run begins execution of an application instance."
                  + "// The instance must be in state NotRunning."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(org.joda.time.Duration.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "kill",
              "// Kill attempts a clean shutdown an of application instance."
                  + "// The instance must be in state Running."
                  + "//"
                  + "// If the deadline is non-zero and the instance in question is still"
                  + "// running after the given deadline, shutdown of the instance is"
                  + "// enforced."
                  + "//"
                  + "// If called against a Device, causes the Device to stop itself (which"
                  + "// may or may not result in a restart depending on the device manager"
                  + "// setup)."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "update",
              "// Update updates an application installation's version to a new version"
                  + "// created from the envelope at the object name provided during Install."
                  + "// If the new application envelope contains a different application"
                  + "// title, the update does not occur, and an error is returned.  The"
                  + "// installation must be in state Active."
                  + "//"
                  + "// Update updates an application instance's version to the current"
                  + "// installation version.  The instance must be in state NotRunning."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "updateTo",
              "// UpdateTo updates the application installation(s) to the application"
                  + "// specified by the object name argument.  If the new application"
                  + "// envelope contains a different application title, the update does not"
                  + "// occur, and an error is returned."
                  + "// The installation must be in state Active."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "revert",
              "// Revert reverts an application installation's version to the previous"
                  + "// version of its current version.  The installation must be in state"
                  + "// Active."
                  + "//"
                  + "// Revert reverts an application instance's version to the previous"
                  + "// version of its current version.  The instance must be in state"
                  + "// NotRunning."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "debug",
              "// Debug returns debug information about the application installation or"
                  + "// instance.  This is generally highly implementation-specific, and"
                  + "// presented in an unstructured form.  No guarantees are given about the"
                  + "// stability of the format, and parsing it programmatically is"
                  + "// specifically discouraged."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(io.v.v23.services.device.Status.class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      tags.add(
          new io.v.v23.vdl.VdlAny(
              io.v.v23.vdl.VdlValue.valueOf(
                  new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class)));

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "status",
              "// Status returns structured information about the application"
                  + "// installation or instance."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "Application",
        "io.v.v23.services.device",
        "// Application can be used to manage applications on a device. This interface"
            + "// will be invoked using an object name that identifies the application and its"
            + "// installations and instances where applicable."
            + "//"
            + "// An application is defined by a title.  An application can have multiple"
            + "// installations on a device.  The installations are grouped under the same"
            + "// application, but are otherwise independent of each other.  Each installation"
            + "// can have zero or more instances (which can be running or not).  The instances"
            + "// are independent of each other, and do not share state (like local storage)."
            + "// Interaction among instances should occur via Vanadium RPC, facilitated by the"
            + "// local mounttable."
            + "//"
            + "// The device manager supports versioning of applications.  Each installation"
            + "// maintains a tree of versions, where a version is defined by a specific"
            + "// envelope.  The tree structure comes from 'previous version' references: each"
            + "// version (except the initial installation version) maintains a reference to"
            + "// the version that preceded it.  The installation maintains a current version"
            + "// reference that is used for new instances.  Each update operation on the"
            + "// installation creates a new version, sets the previous reference of the new"
            + "// version to the current version, and then updates the current version to refer"
            + "// to the new version.  Each revert operation on the installation sets the"
            + "// current version to the previous version of the current version.  Each"
            + "// instance maintains a current version reference that is used to run the"
            + "// instance.  The initial version of the instance is set to the current version"
            + "// of the installation at the time of instantiation.  Each update operation on"
            + "// the instance updates the instance's current version to the current version of"
            + "// the installation.  Each revert operation on the instance updates the"
            + "// instance's current version to the previous version of the instance's version."
            + "//"
            + "// The Application interface methods can be divided based on their intended"
            + "// receiver:"
            + "//"
            + "// 1) Method receiver is an application:"
            + "//     - Install()"
            + "//"
            + "// 2) Method receiver is an application installation:"
            + "//     - Instantiate()"
            + "//     - Uninstall()"
            + "//"
            + "// 3) Method receiver is an application instance:"
            + "//     - Run()"
            + "//     - Kill()"
            + "//     - Delete()"
            + "//"
            + "// 4) Method receiver is an application installation or instance:"
            + "//     - Update()"
            + "//     - Revert()"
            + "//"
            + "// The following methods complement one another:"
            + "//     - Install() and Uninstall()"
            + "//     - Instantiate() and Delete()"
            + "//     - Run() and Kill()"
            + "//     - Update() and Revert()"
            + "//"
            + "//"
            + "//"
            + "// Examples:"
            + "//"
            + "// Install Google Maps on the device."
            + "//     device/apps.Install(\"/google.com/appstore/maps\", nil, nil) --> \"google maps/0\""
            + "//"
            + "// Create and start an instance of the previously installed maps application"
            + "// installation."
            + "//    device/apps/google maps/0.Instantiate() --> { \"0\" }"
            + "//    device/apps/google maps/0/0.Run()"
            + "//"
            + "// Create and start a second instance of the previously installed maps"
            + "// application installation."
            + "//    device/apps/google maps/0.Instantiate() --> { \"1\" }"
            + "//    device/apps/google maps/0/1.Run()"
            + "//"
            + "// Kill and delete the first instance previously started."
            + "//    device/apps/google maps/0/0.Kill()"
            + "//    device/apps/google maps/0/0.Delete()"
            + "//"
            + "// Install a second Google Maps installation."
            + "//    device/apps.Install(\"/google.com/appstore/maps\", nil, nil) --> \"google maps/1\""
            + "//"
            + "// Update the second maps installation to the latest version available."
            + "//    device/apps/google maps/1.Update()"
            + "//"
            + "// Update the first maps installation to a specific version."
            + "//    device/apps/google maps/0.UpdateTo(\"/google.com/appstore/beta/maps\")"
            + "//"
            + "// Finally, an application installation instance can be in one of three abstract"
            + "// states: 1) \"does not exist/deleted\", 2) \"running\", or 3) \"not-running\". The"
            + "// interface methods transition between these abstract states using the"
            + "// following state machine:"
            + "//"
            + "//    apply(Instantiate(), \"does not exist\") = \"not-running\""
            + "//    apply(Run(), \"not-running\") = \"running\""
            + "//    apply(Kill(), \"running\") = \"not-running\""
            + "//    apply(Delete(), \"not-running\") = \"deleted\""
            + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("debug".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Debug"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"debug\": %s", e.getMessage()));
      }
    }

    if ("delete".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
      }
    }

    if ("install".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"install\": %s", e.getMessage()));
      }
    }

    if ("instantiate".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"instantiate\": %s", e.getMessage()));
      }
    }

    if ("kill".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"kill\": %s", e.getMessage()));
      }
    }

    if ("revert".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"revert\": %s", e.getMessage()));
      }
    }

    if ("run".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Write"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"run\": %s", e.getMessage()));
      }
    }

    if ("status".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Read"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"status\": %s", e.getMessage()));
      }
    }

    if ("uninstall".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"uninstall\": %s", e.getMessage()));
      }
    }

    if ("update".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"update\": %s", e.getMessage()));
      }
    }

    if ("updateTo".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {
          io.v.v23.vdl.VdlValue.valueOf(
              new io.v.v23.security.access.Tag("Admin"), io.v.v23.security.access.Tag.class),
        };
      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"updateTo\": %s", e.getMessage()));
      }
    }

    {
      io.v.v23.vdl.VdlValue[] tags = this.wrapperObject.getMethodTags(method);
      if (tags != null) {
        return tags;
      }
    }

    return null; // method not found
  }

  /**
   * Install installs the application identified by the first argument and
   * returns an object name suffix that identifies the new installation.
   *<p>
   * The name argument should be an object name for an application
   * envelope.  The service it identifies must implement
   * repository.Application, and is expected to return either the
   * requested version (if the object name encodes a specific version), or
   * otherwise the latest available version, as appropriate.  This object
   * name will be used by default by the Update method, as a source for
   * updated application envelopes (can be overriden by setting
   * AppOriginConfigKey in the config).
   *<p>
   * The config argument specifies config settings that will take
   * precedence over those present in the application envelope.
   *<p>
   * The packages argument specifies packages to be installed in addition
   * to those specified in the envelope.  If a package in the envelope has
   * the same key, the package in the packages argument takes precedence.
   *<p>
   * The returned suffix, when appended to the name used to reach the
   * receiver for Install, can be used to control the installation object.
   * The suffix will contain the title of the application as a prefix,
   * which can then be used to control all the installations of the given
   * application.
   * TODO(rjkroege): Use customized labels.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> install(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String name,
      final io.v.v23.services.device.Config config,
      final io.v.v23.services.application.Packages packages) {

    return this.server.install(_ctx, _call, name, config, packages);
  }

  /**
   * Uninstall uninstalls an application installation.
   * The installation must be in state Active.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> uninstall(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.uninstall(_ctx, _call);
  }

  /**
   * Instantiate creates an instance of an application installation.
   * The installation must be in state Active.
   *<p>
   * The server sends the application instance's Public Key on the stream.
   * When the client receives the Public Key it must send Blessings back
   * to the server. When the instance is created, the server returns the
   * instance name to the client.
   *<p>
   * Client                       Server
   *  "object".Instantiate() -->
   *                         <--  InstancePublicKey
   *  AppBlessings           -->
   *                         <--  return InstanceName
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> instantiate(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    io.v.v23.vdl.ServerStream<
            io.v.v23.services.device.BlessServerMessage,
            io.v.v23.services.device.BlessClientMessage>
        _stream =
            new io.v.v23.vdl.ServerStream<
                io.v.v23.services.device.BlessServerMessage,
                io.v.v23.services.device.BlessClientMessage>() {
              @Override
              public com.google.common.util.concurrent.ListenableFuture<Void> send(
                  io.v.v23.services.device.BlessServerMessage _item) {
                java.lang.reflect.Type _type = io.v.v23.services.device.BlessServerMessage.class;
                return _call.send(_item, _type);
              }

              @Override
              public com.google.common.util.concurrent.ListenableFuture<
                      io.v.v23.services.device.BlessClientMessage>
                  recv() {
                java.lang.reflect.Type _type = io.v.v23.services.device.BlessClientMessage.class;
                return com.google.common.util.concurrent.Futures.transform(
                    _call.recv(_type),
                    new com.google.common.base.Function<
                        Object, io.v.v23.services.device.BlessClientMessage>() {
                      @Override
                      public io.v.v23.services.device.BlessClientMessage apply(Object result) {
                        return (io.v.v23.services.device.BlessClientMessage) result;
                      }
                    });
              }
            };

    return this.server.instantiate(_ctx, _call, _stream);
  }

  /**
   * Delete deletes an instance.  Once deleted, the instance cannot be
   * revived.
   * The instance must be in state NotRunning.
   *<p>
   * If called against a Device, causes the Device to shut itself down.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.delete(_ctx, _call);
  }

  /**
   * Run begins execution of an application instance.
   * The instance must be in state NotRunning.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> run(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.run(_ctx, _call);
  }

  /**
   * Kill attempts a clean shutdown an of application instance.
   * The instance must be in state Running.
   *<p>
   * If the deadline is non-zero and the instance in question is still
   * running after the given deadline, shutdown of the instance is
   * enforced.
   *<p>
   * If called against a Device, causes the Device to stop itself (which
   * may or may not result in a restart depending on the device manager
   * setup).
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> kill(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final org.joda.time.Duration deadline) {

    return this.server.kill(_ctx, _call, deadline);
  }

  /**
   * Update updates an application installation's version to a new version
   * created from the envelope at the object name provided during Install.
   * If the new application envelope contains a different application
   * title, the update does not occur, and an error is returned.  The
   * installation must be in state Active.
   *<p>
   * Update updates an application instance's version to the current
   * installation version.  The instance must be in state NotRunning.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> update(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.update(_ctx, _call);
  }

  /**
   * UpdateTo updates the application installation(s) to the application
   * specified by the object name argument.  If the new application
   * envelope contains a different application title, the update does not
   * occur, and an error is returned.
   * The installation must be in state Active.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> updateTo(
      io.v.v23.context.VContext _ctx,
      final io.v.v23.rpc.StreamServerCall _call,
      final java.lang.String name) {

    return this.server.updateTo(_ctx, _call, name);
  }

  /**
   * Revert reverts an application installation's version to the previous
   * version of its current version.  The installation must be in state
   * Active.
   *<p>
   * Revert reverts an application instance's version to the previous
   * version of its current version.  The instance must be in state
   * NotRunning.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> revert(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.revert(_ctx, _call);
  }

  /**
   * Debug returns debug information about the application installation or
   * instance.  This is generally highly implementation-specific, and
   * presented in an unstructured form.  No guarantees are given about the
   * stability of the format, and parsing it programmatically is
   * specifically discouraged.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.String> debug(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.debug(_ctx, _call);
  }

  /**
   * Status returns structured information about the application
   * installation or instance.
   */
  public com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Status> status(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.status(_ctx, _call);
  }

  /**
   * GetPermissions returns the complete, current Permissions for an object. The
   * returned version can be passed to a subsequent call to SetPermissions for
   * optimistic concurrency control. A successful call to SetPermissions will
   * invalidate version, and the client must call GetPermissions again to get
   * the current version.
   */
  public com.google.common.util.concurrent.ListenableFuture<
          io.v.v23.services.permissions.ObjectServer.GetPermissionsOut>
      getPermissions(io.v.v23.context.VContext ctx, io.v.v23.rpc.StreamServerCall call)
          throws io.v.v23.verror.VException {

    return this.wrapperObject.getPermissions(ctx, call);
  }

  /**
   * SetPermissions replaces the current Permissions for an object.  version
   * allows for optional, optimistic concurrency control.  If non-empty,
   * version's value must come from GetPermissions.  If any client has
   * successfully called SetPermissions in the meantime, the version will be
   * stale and SetPermissions will fail.  If empty, SetPermissions performs an
   * unconditional update.
   *<p>
   * Permissions objects are expected to be small.  It is up to the
   * implementation to define the exact limit, though it should probably be
   * around 100KB.  Large lists of principals can be represented concisely using
   * blessings.
   *<p>
   * There is some ambiguity when calling SetPermissions on a mount point.
   * Does it affect the mount itself or does it affect the service endpoint
   * that the mount points to?  The chosen behavior is that it affects the
   * service endpoint.  To modify the mount point's Permissions, use
   * ResolveToMountTable to get an endpoint and call SetPermissions on that.
   * This means that clients must know when a name refers to a mount point to
   * change its Permissions.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> setPermissions(
      io.v.v23.context.VContext ctx,
      io.v.v23.rpc.StreamServerCall call,
      final io.v.v23.security.access.Permissions perms,
      final java.lang.String version)
      throws io.v.v23.verror.VException {

    return this.wrapperObject.setPermissions(ctx, call, perms, version);
  }
}
