// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: device.vdl
package io.v.v23.services.device;

/**
 * Application can be used to manage applications on a device. This interface
 * will be invoked using an object name that identifies the application and its
 * installations and instances where applicable.
 *<p>
 * An application is defined by a title.  An application can have multiple
 * installations on a device.  The installations are grouped under the same
 * application, but are otherwise independent of each other.  Each installation
 * can have zero or more instances (which can be running or not).  The instances
 * are independent of each other, and do not share state (like local storage).
 * Interaction among instances should occur via Vanadium RPC, facilitated by the
 * local mounttable.
 *<p>
 * The device manager supports versioning of applications.  Each installation
 * maintains a tree of versions, where a version is defined by a specific
 * envelope.  The tree structure comes from 'previous version' references: each
 * version (except the initial installation version) maintains a reference to
 * the version that preceded it.  The installation maintains a current version
 * reference that is used for new instances.  Each update operation on the
 * installation creates a new version, sets the previous reference of the new
 * version to the current version, and then updates the current version to refer
 * to the new version.  Each revert operation on the installation sets the
 * current version to the previous version of the current version.  Each
 * instance maintains a current version reference that is used to run the
 * instance.  The initial version of the instance is set to the current version
 * of the installation at the time of instantiation.  Each update operation on
 * the instance updates the instance's current version to the current version of
 * the installation.  Each revert operation on the instance updates the
 * instance's current version to the previous version of the instance's version.
 *<p>
 * The Application interface methods can be divided based on their intended
 * receiver:
 *<p>
 * 1) Method receiver is an application:
 *     - Install()
 *<p>
 * 2) Method receiver is an application installation:
 *     - Instantiate()
 *     - Uninstall()
 *<p>
 * 3) Method receiver is an application instance:
 *     - Run()
 *     - Kill()
 *     - Delete()
 *<p>
 * 4) Method receiver is an application installation or instance:
 *     - Update()
 *     - Revert()
 *<p>
 * The following methods complement one another:
 *     - Install() and Uninstall()
 *     - Instantiate() and Delete()
 *     - Run() and Kill()
 *     - Update() and Revert()
 *<p>
 *<p>
 *<p>
 * Examples:
 *<p>
 * Install Google Maps on the device.
 *     device/apps.Install("/google.com/appstore/maps", nil, nil) --> "google maps/0"
 *<p>
 * Create and start an instance of the previously installed maps application
 * installation.
 *    device/apps/google maps/0.Instantiate() --> { "0" }
 *    device/apps/google maps/0/0.Run()
 *<p>
 * Create and start a second instance of the previously installed maps
 * application installation.
 *    device/apps/google maps/0.Instantiate() --> { "1" }
 *    device/apps/google maps/0/1.Run()
 *<p>
 * Kill and delete the first instance previously started.
 *    device/apps/google maps/0/0.Kill()
 *    device/apps/google maps/0/0.Delete()
 *<p>
 * Install a second Google Maps installation.
 *    device/apps.Install("/google.com/appstore/maps", nil, nil) --> "google maps/1"
 *<p>
 * Update the second maps installation to the latest version available.
 *    device/apps/google maps/1.Update()
 *<p>
 * Update the first maps installation to a specific version.
 *    device/apps/google maps/0.UpdateTo("/google.com/appstore/beta/maps")
 *<p>
 * Finally, an application installation instance can be in one of three abstract
 * states: 1) "does not exist/deleted", 2) "running", or 3) "not-running". The
 * interface methods transition between these abstract states using the
 * following state machine:
 *<p>
 *    apply(Instantiate(), "does not exist") = "not-running"
 *    apply(Run(), "not-running") = "running"
 *    apply(Kill(), "running") = "not-running"
 *    apply(Delete(), "not-running") = "deleted"
 */
@io.v.v23.vdl.VServer(serverWrapper = io.v.v23.services.device.ApplicationServerWrapper.class)
public interface ApplicationServer extends io.v.v23.services.permissions.ObjectServer {

  /**
   * Install installs the application identified by the first argument and
   * returns an object name suffix that identifies the new installation.
   *<p>
   * The name argument should be an object name for an application
   * envelope.  The service it identifies must implement
   * repository.Application, and is expected to return either the
   * requested version (if the object name encodes a specific version), or
   * otherwise the latest available version, as appropriate.  This object
   * name will be used by default by the Update method, as a source for
   * updated application envelopes (can be overriden by setting
   * AppOriginConfigKey in the config).
   *<p>
   * The config argument specifies config settings that will take
   * precedence over those present in the application envelope.
   *<p>
   * The packages argument specifies packages to be installed in addition
   * to those specified in the envelope.  If a package in the envelope has
   * the same key, the package in the packages argument takes precedence.
   *<p>
   * The returned suffix, when appended to the name used to reach the
   * receiver for Install, can be used to control the installation object.
   * The suffix will contain the title of the application as a prefix,
   * which can then be used to control all the installations of the given
   * application.
   * TODO(rjkroege): Use customized labels.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> install(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final java.lang.String name,
      final io.v.v23.services.device.Config config,
      final io.v.v23.services.application.Packages packages);

  /**
   * Uninstall uninstalls an application installation.
   * The installation must be in state Active.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> uninstall(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Instantiate creates an instance of an application installation.
   * The installation must be in state Active.
   *<p>
   * The server sends the application instance's Public Key on the stream.
   * When the client receives the Public Key it must send Blessings back
   * to the server. When the instance is created, the server returns the
   * instance name to the client.
   *<p>
   * Client                       Server
   *  "object".Instantiate() -->
   *                         <--  InstancePublicKey
   *  AppBlessings           -->
   *                         <--  return InstanceName
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> instantiate(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      io.v.v23.vdl.ServerStream<
              io.v.v23.services.device.BlessServerMessage,
              io.v.v23.services.device.BlessClientMessage>
          stream);

  /**
   * Delete deletes an instance.  Once deleted, the instance cannot be
   * revived.
   * The instance must be in state NotRunning.
   *<p>
   * If called against a Device, causes the Device to shut itself down.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> delete(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Run begins execution of an application instance.
   * The instance must be in state NotRunning.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> run(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Kill attempts a clean shutdown an of application instance.
   * The instance must be in state Running.
   *<p>
   * If the deadline is non-zero and the instance in question is still
   * running after the given deadline, shutdown of the instance is
   * enforced.
   *<p>
   * If called against a Device, causes the Device to stop itself (which
   * may or may not result in a restart depending on the device manager
   * setup).
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> kill(
      io.v.v23.context.VContext context,
      io.v.v23.rpc.ServerCall call,
      final org.joda.time.Duration deadline);

  /**
   * Update updates an application installation's version to a new version
   * created from the envelope at the object name provided during Install.
   * If the new application envelope contains a different application
   * title, the update does not occur, and an error is returned.  The
   * installation must be in state Active.
   *<p>
   * Update updates an application instance's version to the current
   * installation version.  The instance must be in state NotRunning.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> update(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * UpdateTo updates the application installation(s) to the application
   * specified by the object name argument.  If the new application
   * envelope contains a different application title, the update does not
   * occur, and an error is returned.
   * The installation must be in state Active.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> updateTo(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call, final java.lang.String name);

  /**
   * Revert reverts an application installation's version to the previous
   * version of its current version.  The installation must be in state
   * Active.
   *<p>
   * Revert reverts an application instance's version to the previous
   * version of its current version.  The instance must be in state
   * NotRunning.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.Void> revert(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Debug returns debug information about the application installation or
   * instance.  This is generally highly implementation-specific, and
   * presented in an unstructured form.  No guarantees are given about the
   * stability of the format, and parsing it programmatically is
   * specifically discouraged.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<java.lang.String> debug(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);

  /**
   * Status returns structured information about the application
   * installation or instance.
   */
  @javax.annotation.CheckReturnValue
  com.google.common.util.concurrent.ListenableFuture<io.v.v23.services.device.Status> status(
      io.v.v23.context.VContext context, io.v.v23.rpc.ServerCall call);
}
