// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: binary.vdl
package io.v.v23.services.binary;

/**
 * PartInfo holds information describing a binary part.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/binary.PartInfo")
public class PartInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Checksum", index = 0)
  private java.lang.String checksum;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Size", index = 1)
  private long size;

  /**
   * Vdl type for {@link PartInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(PartInfo.class);

  /**
   * Creates a new zero-value instance of {@link PartInfo}.
   */
  public PartInfo() {
    super(VDL_TYPE);

    this.checksum = "";

    this.size = 0L;
  }

  /**
   * Creates a new instance of {@link PartInfo} with the provided field values.
   */
  public PartInfo(java.lang.String checksum, long size) {
    super(VDL_TYPE);

    this.checksum = checksum;

    this.size = size;
  }

  /**
   * Checksum holds the hex-encoded MD5 checksum of the binary part.
   */
  public java.lang.String getChecksum() {
    return this.checksum;
  }

  /**
   * Checksum holds the hex-encoded MD5 checksum of the binary part.
   */
  public void setChecksum(java.lang.String checksum) {
    this.checksum = checksum;
  }

  /**
   * Size holds the binary part size in bytes.
   */
  public long getSize() {
    return this.size;
  }

  /**
   * Size holds the binary part size in bytes.
   */
  public void setSize(long size) {
    this.size = size;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    PartInfo other = (PartInfo) obj;

    if (this.checksum == null) {
      if (other.checksum != null) {
        return false;
      }
    } else if (!this.checksum.equals(other.checksum)) {
      return false;
    }

    if (this.size != other.size) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.checksum == null ? 0 : this.checksum.hashCode());

    result = prime * result + java.lang.Long.valueOf(this.size).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "checksum:" + this.checksum;

    result += ", ";

    result += "size:" + this.size;

    return result + "}";
  }
}
