// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: binary.vdl
package io.v.v23.services.binary;

/**
 * Description describes a binary. Binaries are named and have been
 * determined to run on some set of profiles. The mechanism for
 * determing profiles is specifically not specified and left to the
 * implementation of the interface that generates the description.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/binary.Description")
public class Description extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Name", index = 0)
  private java.lang.String name;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Profiles", index = 1)
  private java.util.Map<java.lang.String, java.lang.Boolean> profiles;

  /**
   * Vdl type for {@link Description}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Description.class);

  /**
   * Creates a new zero-value instance of {@link Description}.
   */
  public Description() {
    super(VDL_TYPE);

    this.name = "";

    this.profiles = new java.util.HashMap<java.lang.String, java.lang.Boolean>();
  }

  /**
   * Creates a new instance of {@link Description} with the provided field values.
   */
  public Description(
      java.lang.String name, java.util.Map<java.lang.String, java.lang.Boolean> profiles) {
    super(VDL_TYPE);

    this.name = name;

    this.profiles = profiles;
  }

  /**
   * Name is the Object name of the application binary that can
   * be used to fetch the actual binary from a content server.
   */
  public java.lang.String getName() {
    return this.name;
  }

  /**
   * Name is the Object name of the application binary that can
   * be used to fetch the actual binary from a content server.
   */
  public void setName(java.lang.String name) {
    this.name = name;
  }

  /**
   * Profiles is a set of names of compatible profiles.  Each
   * name can either be an Object name that resolves to a
   * Profile, or can be the profile's label, e.g.:
   *<p>
   *   "profiles/google/cluster/diskfull"
   *   "linux-media"
   *<p>
   * Application developers can specify compatible profiles by
   * hand, but we also want to be able to automatically derive
   * the matching profiles from examining the binary itself
   * (e.g. that's what Build.Describe() does).
   */
  public java.util.Map<java.lang.String, java.lang.Boolean> getProfiles() {
    return this.profiles;
  }

  /**
   * Profiles is a set of names of compatible profiles.  Each
   * name can either be an Object name that resolves to a
   * Profile, or can be the profile's label, e.g.:
   *<p>
   *   "profiles/google/cluster/diskfull"
   *   "linux-media"
   *<p>
   * Application developers can specify compatible profiles by
   * hand, but we also want to be able to automatically derive
   * the matching profiles from examining the binary itself
   * (e.g. that's what Build.Describe() does).
   */
  public void setProfiles(java.util.Map<java.lang.String, java.lang.Boolean> profiles) {
    this.profiles = profiles;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Description other = (Description) obj;

    if (this.name == null) {
      if (other.name != null) {
        return false;
      }
    } else if (!this.name.equals(other.name)) {
      return false;
    }

    if (this.profiles == null) {
      if (other.profiles != null) {
        return false;
      }
    } else if (!this.profiles.equals(other.profiles)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.name == null ? 0 : this.name.hashCode());

    result = prime * result + (this.profiles == null ? 0 : this.profiles.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "name:" + this.name;

    result += ", ";

    result += "profiles:" + this.profiles;

    return result + "}";
  }
}
