// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: application.vdl
package io.v.v23.services.application;

/**
 * SignedFile represents a file accompanied by a signature of its contents.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/application.SignedFile")
public class SignedFile extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "File", index = 0)
  private java.lang.String file;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Signature", index = 1)
  private io.v.v23.security.VSignature signature;

  /**
   * Vdl type for {@link SignedFile}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SignedFile.class);

  /**
   * Creates a new zero-value instance of {@link SignedFile}.
   */
  public SignedFile() {
    super(VDL_TYPE);

    this.file = "";

    this.signature = new io.v.v23.security.VSignature();
  }

  /**
   * Creates a new instance of {@link SignedFile} with the provided field values.
   */
  public SignedFile(java.lang.String file, io.v.v23.security.VSignature signature) {
    super(VDL_TYPE);

    this.file = file;

    this.signature = signature;
  }

  /**
   *  File is the object name of the file.
   */
  public java.lang.String getFile() {
    return this.file;
  }

  /**
   *  File is the object name of the file.
   */
  public void setFile(java.lang.String file) {
    this.file = file;
  }

  /**
   * Signature represents a signature on the sha256 hash of the file
   * contents by the publisher principal.
   */
  public io.v.v23.security.VSignature getSignature() {
    return this.signature;
  }

  /**
   * Signature represents a signature on the sha256 hash of the file
   * contents by the publisher principal.
   */
  public void setSignature(io.v.v23.security.VSignature signature) {
    this.signature = signature;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SignedFile other = (SignedFile) obj;

    if (this.file == null) {
      if (other.file != null) {
        return false;
      }
    } else if (!this.file.equals(other.file)) {
      return false;
    }

    if (this.signature == null) {
      if (other.signature != null) {
        return false;
      }
    } else if (!this.signature.equals(other.signature)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.file == null ? 0 : this.file.hashCode());

    result = prime * result + (this.signature == null ? 0 : this.signature.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "file:" + this.file;

    result += ", ";

    result += "signature:" + this.signature;

    return result + "}";
  }
}
