// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: application.vdl

package io.v.v23.services.application;

/**
 * Packages represents a set of packages. The map key is the local
 * file/directory name, relative to the instance's packages directory, where the
 * package should be installed. For archives, this name represents a directory
 * into which the archive is to be extracted, and for regular files it
 * represents the name for the file.  The map value is the package
 * specification.
 *<p>
 * Each object's media type determines how to install it.
 *<p>
 * For example, with key=pkg1,value=SignedFile{File:binaryrepo/configfiles} (an
 * archive), the "configfiles" package will be installed under the "pkg1"
 * directory. With key=pkg2,value=SignedFile{File:binaryrepo/binfile} (a
 * binary), the "binfile" file will be installed as the "pkg2" file.
 *<p>
 * The keys must be valid file/directory names, without path separators.
 *<p>
 * Any number of packages may be specified.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/application.Packages")
public class Packages
    extends io.v.v23.vdl.VdlMap<java.lang.String, io.v.v23.services.application.SignedFile> {
  private static final long serialVersionUID = 1L;

  /**
   * Vdl type for {@link Packages}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Packages.class);

  /**
   * Creates a new instance of {@link Packages} with the given underlying value.
   *
   * @param impl underlying value
   */
  public Packages(java.util.Map<java.lang.String, io.v.v23.services.application.SignedFile> impl) {
    super(VDL_TYPE, impl);
  }

  /**
   * Creates a new empty instance of {@link Packages}.
   */
  public Packages() {
    this(new java.util.HashMap<java.lang.String, io.v.v23.services.application.SignedFile>());
  }
}
