// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: application.vdl
package io.v.v23.services.application;

/**
 * Envelope is a collection of metadata that describes an application.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/application.Envelope")
public class Envelope extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Title", index = 0)
  private java.lang.String title;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Args", index = 1)
  private java.util.List<java.lang.String> args;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Binary", index = 2)
  private io.v.v23.services.application.SignedFile binary;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Publisher", index = 3)
  private io.v.v23.security.Blessings publisher;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Env", index = 4)
  private java.util.List<java.lang.String> env;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Packages", index = 5)
  private io.v.v23.services.application.Packages packages;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Restarts", index = 6)
  private int restarts;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RestartTimeWindow", index = 7)
  private org.joda.time.Duration restartTimeWindow;

  /**
   * Vdl type for {@link Envelope}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Envelope.class);

  /**
   * Creates a new zero-value instance of {@link Envelope}.
   */
  public Envelope() {
    super(VDL_TYPE);

    this.title = "";

    this.args = new java.util.ArrayList<java.lang.String>();

    this.binary = new io.v.v23.services.application.SignedFile();

    this.publisher = null;

    this.env = new java.util.ArrayList<java.lang.String>();

    this.packages = new io.v.v23.services.application.Packages();

    this.restarts = 0;

    this.restartTimeWindow = null;
  }

  /**
   * Creates a new instance of {@link Envelope} with the provided field values.
   */
  public Envelope(
      java.lang.String title,
      java.util.List<java.lang.String> args,
      io.v.v23.services.application.SignedFile binary,
      io.v.v23.security.Blessings publisher,
      java.util.List<java.lang.String> env,
      io.v.v23.services.application.Packages packages,
      int restarts,
      org.joda.time.Duration restartTimeWindow) {
    super(VDL_TYPE);

    this.title = title;

    this.args = args;

    this.binary = binary;

    this.publisher = publisher;

    this.env = env;

    this.packages = packages;

    this.restarts = restarts;

    this.restartTimeWindow = restartTimeWindow;
  }

  /**
   * Title is the publisher-assigned application title.  Application
   * installations with the same title are considered as belonging to the
   * same application by the application management system.
   *<p>
   * A change in the title signals a new application.
   */
  public java.lang.String getTitle() {
    return this.title;
  }

  /**
   * Title is the publisher-assigned application title.  Application
   * installations with the same title are considered as belonging to the
   * same application by the application management system.
   *<p>
   * A change in the title signals a new application.
   */
  public void setTitle(java.lang.String title) {
    this.title = title;
  }

  /**
   * Args is an array of command-line arguments to be used when executing
   * the binary.
   */
  public java.util.List<java.lang.String> getArgs() {
    return this.args;
  }

  /**
   * Args is an array of command-line arguments to be used when executing
   * the binary.
   */
  public void setArgs(java.util.List<java.lang.String> args) {
    this.args = args;
  }

  /**
   * Binary identifies the application binary.
   */
  public io.v.v23.services.application.SignedFile getBinary() {
    return this.binary;
  }

  /**
   * Binary identifies the application binary.
   */
  public void setBinary(io.v.v23.services.application.SignedFile binary) {
    this.binary = binary;
  }

  /**
   * Publisher represents the set of blessings that have been bound to
   * the principal who published this binary.
   */
  public io.v.v23.security.Blessings getPublisher() {
    return this.publisher;
  }

  /**
   * Publisher represents the set of blessings that have been bound to
   * the principal who published this binary.
   */
  public void setPublisher(io.v.v23.security.Blessings publisher) {
    this.publisher = publisher;
  }

  /**
   * Env is an array that stores the environment variable values to be
   * used when executing the binary.
   */
  public java.util.List<java.lang.String> getEnv() {
    return this.env;
  }

  /**
   * Env is an array that stores the environment variable values to be
   * used when executing the binary.
   */
  public void setEnv(java.util.List<java.lang.String> env) {
    this.env = env;
  }

  /**
   * Packages is the set of packages to install on the local filesystem
   * before executing the binary
   */
  public io.v.v23.services.application.Packages getPackages() {
    return this.packages;
  }

  /**
   * Packages is the set of packages to install on the local filesystem
   * before executing the binary
   */
  public void setPackages(io.v.v23.services.application.Packages packages) {
    this.packages = packages;
  }

  /**
   * Restarts specifies how many times the device manager will attempt
   * to automatically restart an application that has crashed before
   * giving up and marking the application as NotRunning.
   */
  public int getRestarts() {
    return this.restarts;
  }

  /**
   * Restarts specifies how many times the device manager will attempt
   * to automatically restart an application that has crashed before
   * giving up and marking the application as NotRunning.
   */
  public void setRestarts(int restarts) {
    this.restarts = restarts;
  }

  /**
   * RestartTimeWindow is the time window within which an
   * application exit is considered a crash that counts against the
   * Restarts budget. If the application crashes after less than
   * RestartTimeWindow time for Restarts consecutive times, the
   * application is marked NotRunning and no more restart attempts
   * are made. If the application has run continuously for more
   * than RestartTimeWindow, subsequent crashes will again benefit
   * from up to Restarts restarts (that is, the Restarts budget is
   * reset by a successful run of at least RestartTimeWindow
   * duration).
   */
  public org.joda.time.Duration getRestartTimeWindow() {
    return this.restartTimeWindow;
  }

  /**
   * RestartTimeWindow is the time window within which an
   * application exit is considered a crash that counts against the
   * Restarts budget. If the application crashes after less than
   * RestartTimeWindow time for Restarts consecutive times, the
   * application is marked NotRunning and no more restart attempts
   * are made. If the application has run continuously for more
   * than RestartTimeWindow, subsequent crashes will again benefit
   * from up to Restarts restarts (that is, the Restarts budget is
   * reset by a successful run of at least RestartTimeWindow
   * duration).
   */
  public void setRestartTimeWindow(org.joda.time.Duration restartTimeWindow) {
    this.restartTimeWindow = restartTimeWindow;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Envelope other = (Envelope) obj;

    if (this.title == null) {
      if (other.title != null) {
        return false;
      }
    } else if (!this.title.equals(other.title)) {
      return false;
    }

    if (this.args == null) {
      if (other.args != null) {
        return false;
      }
    } else if (!this.args.equals(other.args)) {
      return false;
    }

    if (this.binary == null) {
      if (other.binary != null) {
        return false;
      }
    } else if (!this.binary.equals(other.binary)) {
      return false;
    }

    if (this.publisher == null) {
      if (other.publisher != null) {
        return false;
      }
    } else if (!this.publisher.equals(other.publisher)) {
      return false;
    }

    if (this.env == null) {
      if (other.env != null) {
        return false;
      }
    } else if (!this.env.equals(other.env)) {
      return false;
    }

    if (this.packages == null) {
      if (other.packages != null) {
        return false;
      }
    } else if (!this.packages.equals(other.packages)) {
      return false;
    }

    if (this.restarts != other.restarts) {
      return false;
    }

    if (this.restartTimeWindow == null) {
      if (other.restartTimeWindow != null) {
        return false;
      }
    } else if (!this.restartTimeWindow.equals(other.restartTimeWindow)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.title == null ? 0 : this.title.hashCode());

    result = prime * result + (this.args == null ? 0 : this.args.hashCode());

    result = prime * result + (this.binary == null ? 0 : this.binary.hashCode());

    result = prime * result + (this.publisher == null ? 0 : this.publisher.hashCode());

    result = prime * result + (this.env == null ? 0 : this.env.hashCode());

    result = prime * result + (this.packages == null ? 0 : this.packages.hashCode());

    result = prime * result + this.restarts;

    result =
        prime * result + (this.restartTimeWindow == null ? 0 : this.restartTimeWindow.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "title:" + this.title;

    result += ", ";

    result += "args:" + this.args;

    result += ", ";

    result += "binary:" + this.binary;

    result += ", ";

    result += "publisher:" + this.publisher;

    result += ", ";

    result += "env:" + this.env;

    result += ", ";

    result += "packages:" + this.packages;

    result += ", ";

    result += "restarts:" + this.restarts;

    result += ", ";

    result += "restartTimeWindow:" + this.restartTimeWindow;

    return result + "}";
  }
}
