// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: appcycle.vdl
package io.v.v23.services.appcycle;

/**
 * Task is streamed by Stop to provide the client with a sense of the progress
 * of the shutdown.
 * The meaning of Progress and Goal are up to the developer (the server provides
 * the framework with values for these).  The recommended meanings are:
 * - Progress: how far along the shutdown sequence the server is.  This should
 *   be a monotonically increasing number.
 * - Goal: when Progress reaches this value, the shutdown is expected to
 *   complete.  This should not change during a stream, but could change if
 *   e.g. new shutdown tasks are triggered that were not forseen at the outset
 *   of the shutdown.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/services/appcycle.Task")
public class Task extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Progress", index = 0)
  private int progress;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Goal", index = 1)
  private int goal;

  /**
   * Vdl type for {@link Task}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Task.class);

  /**
   * Creates a new zero-value instance of {@link Task}.
   */
  public Task() {
    super(VDL_TYPE);

    this.progress = 0;

    this.goal = 0;
  }

  /**
   * Creates a new instance of {@link Task} with the provided field values.
   */
  public Task(int progress, int goal) {
    super(VDL_TYPE);

    this.progress = progress;

    this.goal = goal;
  }

  public int getProgress() {
    return this.progress;
  }

  public void setProgress(int progress) {
    this.progress = progress;
  }

  public int getGoal() {
    return this.goal;
  }

  public void setGoal(int goal) {
    this.goal = goal;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Task other = (Task) obj;

    if (this.progress != other.progress) {
      return false;
    }

    if (this.goal != other.goal) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + this.progress;

    result = prime * result + this.goal;

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "progress:" + this.progress;

    result += ", ";

    result += "goal:" + this.goal;

    return result + "}";
  }
}
