// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  appcycle.vdl
package io.v.v23.services.appcycle;

/**
 * Wrapper for {@link AppCycleServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class AppCycleServerWrapper {
  private final io.v.v23.services.appcycle.AppCycleServer server;

  /**
   * Creates a new {@link AppCycleServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public AppCycleServerWrapper(io.v.v23.services.appcycle.AppCycleServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "stop",
              "// Stop initiates shutdown of the server.  It streams back periodic"
                  + "// updates to give the client an idea of how the shutdown is"
                  + "// progressing."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "forceStop",
              "// ForceStop tells the server to shut down right away.  It can be issued"
                  + "// while a Stop is outstanding if for example the client does not want"
                  + "// to wait any longer."
                  + "",
              inArgs,
              outArgs,
              null,
              null,
              tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "AppCycle",
        "io.v.v23.services.appcycle",
        "// AppCycle interfaces with the process running a vanadium runtime." + "",
        embeds,
        methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("forceStop".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"forceStop\": %s", e.getMessage()));
      }
    }

    if ("stop".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"stop\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  /**
   * Stop initiates shutdown of the server.  It streams back periodic
   * updates to give the client an idea of how the shutdown is
   * progressing.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> stop(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    io.v.v23.vdl.ServerStream<io.v.v23.services.appcycle.Task, java.lang.Void> _stream =
        new io.v.v23.vdl.ServerStream<io.v.v23.services.appcycle.Task, java.lang.Void>() {
          @Override
          public com.google.common.util.concurrent.ListenableFuture<Void> send(
              io.v.v23.services.appcycle.Task _item) {
            java.lang.reflect.Type _type = io.v.v23.services.appcycle.Task.class;
            return _call.send(_item, _type);
          }

          @Override
          public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> recv() {
            java.lang.reflect.Type _type = java.lang.Void.class;
            return com.google.common.util.concurrent.Futures.transform(
                _call.recv(_type),
                new com.google.common.base.Function<Object, java.lang.Void>() {
                  @Override
                  public java.lang.Void apply(Object result) {
                    return (java.lang.Void) result;
                  }
                });
          }
        };

    return this.server.stop(_ctx, _call, _stream);
  }

  /**
   * ForceStop tells the server to shut down right away.  It can be issued
   * while a Stop is outstanding if for example the client does not want
   * to wait any longer.
   */
  public com.google.common.util.concurrent.ListenableFuture<java.lang.Void> forceStop(
      io.v.v23.context.VContext _ctx, final io.v.v23.rpc.StreamServerCall _call) {

    return this.server.forceStop(_ctx, _call);
  }
}
