// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security.access;

/**
 * AccessList represents a set of blessings that should be granted access.
 *<p>
 * See also: https://vanadium.github.io/glossary.html#access-list
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security/access.AccessList")
public class WireAccessList extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "In", index = 0)
  private java.util.List<io.v.v23.security.BlessingPattern> in;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NotIn", index = 1)
  private java.util.List<java.lang.String> notIn;

  /**
   * Vdl type for {@link WireAccessList}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireAccessList.class);

  /**
   * Creates a new zero-value instance of {@link WireAccessList}.
   */
  public WireAccessList() {
    super(VDL_TYPE);

    this.in = new java.util.ArrayList<io.v.v23.security.BlessingPattern>();

    this.notIn = new java.util.ArrayList<java.lang.String>();
  }

  /**
   * Creates a new instance of {@link WireAccessList} with the provided field values.
   */
  public WireAccessList(
      java.util.List<io.v.v23.security.BlessingPattern> in,
      java.util.List<java.lang.String> notIn) {
    super(VDL_TYPE);

    this.in = in;

    this.notIn = notIn;
  }

  /**
   * In denotes the set of blessings (represented as BlessingPatterns) that
   * should be granted access, unless blacklisted by an entry in NotIn.
   *<p>
   * For example:
   *   In: {"alice:family"}
   * grants access to a principal that presents at least one of
   * "alice:family", "alice:family:friend", "alice:family:friend:spouse" etc.
   * as a blessing.
   */
  public java.util.List<io.v.v23.security.BlessingPattern> getIn() {
    return this.in;
  }

  /**
   * In denotes the set of blessings (represented as BlessingPatterns) that
   * should be granted access, unless blacklisted by an entry in NotIn.
   *<p>
   * For example:
   *   In: {"alice:family"}
   * grants access to a principal that presents at least one of
   * "alice:family", "alice:family:friend", "alice:family:friend:spouse" etc.
   * as a blessing.
   */
  public void setIn(java.util.List<io.v.v23.security.BlessingPattern> in) {
    this.in = in;
  }

  /**
   * NotIn denotes the set of blessings (and their delegates) that
   * have been explicitly blacklisted from the In set.
   *<p>
   * For example:
   *   In: {"alice:friend"}, NotIn: {"alice:friend:bob"}
   * grants access to principals that present "alice:friend",
   * "alice:friend:carol" etc. but NOT to a principal that presents
   * "alice:friend:bob" or "alice:friend:bob:spouse" etc.
   */
  public java.util.List<java.lang.String> getNotIn() {
    return this.notIn;
  }

  /**
   * NotIn denotes the set of blessings (and their delegates) that
   * have been explicitly blacklisted from the In set.
   *<p>
   * For example:
   *   In: {"alice:friend"}, NotIn: {"alice:friend:bob"}
   * grants access to principals that present "alice:friend",
   * "alice:friend:carol" etc. but NOT to a principal that presents
   * "alice:friend:bob" or "alice:friend:bob:spouse" etc.
   */
  public void setNotIn(java.util.List<java.lang.String> notIn) {
    this.notIn = notIn;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireAccessList other = (WireAccessList) obj;

    if (this.in == null) {
      if (other.in != null) {
        return false;
      }
    } else if (!this.in.equals(other.in)) {
      return false;
    }

    if (this.notIn == null) {
      if (other.notIn != null) {
        return false;
      }
    } else if (!this.notIn.equals(other.notIn)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.in == null ? 0 : this.in.hashCode());

    result = prime * result + (this.notIn == null ? 0 : this.notIn.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "in:" + this.in;

    result += ", ";

    result += "notIn:" + this.notIn;

    return result + "}";
  }
}
