// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * WireBlessings encapsulates wire format of a set of blessings and the
 * corresponding cryptographic proof that binds them to a principal
 * (identified by a public key).
 *<p>
 * This structure is the "wire" format for sending and receiving blessings
 * in RPCs or marshaling to persistent storage. Typically, languages will
 * provide a factory function that converts this wire representation to
 * a more usable object to inspect and manipulate these blessings.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.WireBlessings")
public class WireBlessings extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "CertificateChains", index = 0)
  private java.util.List<java.util.List<io.v.v23.security.VCertificate>> certificateChains;

  /**
   * Vdl type for {@link WireBlessings}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireBlessings.class);

  /**
   * Creates a new zero-value instance of {@link WireBlessings}.
   */
  public WireBlessings() {
    super(VDL_TYPE);

    this.certificateChains =
        new java.util.ArrayList<java.util.List<io.v.v23.security.VCertificate>>();
  }

  /**
   * Creates a new instance of {@link WireBlessings} with the provided field values.
   */
  public WireBlessings(
      java.util.List<java.util.List<io.v.v23.security.VCertificate>> certificateChains) {
    super(VDL_TYPE);

    this.certificateChains = certificateChains;
  }

  /**
   * CertificateChains is an array of chains of certificates that bind
   * a blessing to the public key in the last certificate of the chain.
   */
  public java.util.List<java.util.List<io.v.v23.security.VCertificate>> getCertificateChains() {
    return this.certificateChains;
  }

  /**
   * CertificateChains is an array of chains of certificates that bind
   * a blessing to the public key in the last certificate of the chain.
   */
  public void setCertificateChains(
      java.util.List<java.util.List<io.v.v23.security.VCertificate>> certificateChains) {
    this.certificateChains = certificateChains;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    WireBlessings other = (WireBlessings) obj;

    if (this.certificateChains == null) {
      if (other.certificateChains != null) {
        return false;
      }
    } else if (!this.certificateChains.equals(other.certificateChains)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result =
        prime * result + (this.certificateChains == null ? 0 : this.certificateChains.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "certificateChains:" + this.certificateChains;

    return result + "}";
  }
}
