// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * BlessingPattern is a pattern that is matched by specific blessings.
 *<p>
 * A pattern can either be a blessing (slash-separated human-readable string)
 * or a blessing ending in "/$". A pattern ending in "/$" is matched exactly
 * by the blessing specified by the pattern string with the "/$" suffix stripped
 * out. For example, the pattern "a/b/c/$" is matched by exactly by the blessing
 * "a/b/c".
 *<p>
 * A pattern not ending in "/$" is more permissive, and is also matched by blessings
 * that are extensions of the pattern (including the pattern itself). For example, the
 * pattern "a/b/c" is matched by the blessings "a/b/c", "a/b/c/x", "a/b/c/x/y", etc.
 *<p>
 * TODO(ataly, ashankar): Define a formal BNF grammar for blessings and blessing patterns.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.BlessingPattern")
public class WireBlessingPattern extends io.v.v23.vdl.VdlString {
  private static final long serialVersionUID = 1L;

  /**
   * Vdl type for {@link WireBlessingPattern}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(WireBlessingPattern.class);

  /**
   * Creates a new instance of {@link WireBlessingPattern} with the given value.
   *
   * @param value value
   */
  public WireBlessingPattern(java.lang.String value) {
    super(VDL_TYPE, value);
  }

  /**
   * Creates a new zero-value instance of {@link WireBlessingPattern}.
   */
  public WireBlessingPattern() {
    super(VDL_TYPE);
  }
}
