// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * Signature represents a digital signature.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.Signature")
public class VSignature extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Purpose", index = 0)
  private byte[] purpose;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Hash", index = 1)
  private io.v.v23.security.Hash hash;

  @io.v.v23.vdl.GeneratedFromVdl(name = "R", index = 2)
  private byte[] r;

  @io.v.v23.vdl.GeneratedFromVdl(name = "S", index = 3)
  private byte[] s;

  /**
   * Vdl type for {@link VSignature}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(VSignature.class);

  /**
   * Creates a new zero-value instance of {@link VSignature}.
   */
  public VSignature() {
    super(VDL_TYPE);

    this.purpose = new byte[] {};

    this.hash = new io.v.v23.security.Hash();

    this.r = new byte[] {};

    this.s = new byte[] {};
  }

  /**
   * Creates a new instance of {@link VSignature} with the provided field values.
   */
  public VSignature(byte[] purpose, io.v.v23.security.Hash hash, byte[] r, byte[] s) {
    super(VDL_TYPE);

    this.purpose = purpose;

    this.hash = hash;

    this.r = r;

    this.s = s;
  }

  /**
   * Purpose of the signature. Can be used to prevent type attacks.
   * (See Section 4.2 of http://www-users.cs.york.ac.uk/~jac/PublishedPapers/reviewV1_1997.pdf for example).
   * The actual signature (R, S values for ECDSA keys) is produced by signing: Hash(Hash(message), Hash(Purpose)).
   */
  public byte[] getPurpose() {
    return this.purpose;
  }

  /**
   * Purpose of the signature. Can be used to prevent type attacks.
   * (See Section 4.2 of http://www-users.cs.york.ac.uk/~jac/PublishedPapers/reviewV1_1997.pdf for example).
   * The actual signature (R, S values for ECDSA keys) is produced by signing: Hash(Hash(message), Hash(Purpose)).
   */
  public void setPurpose(byte[] purpose) {
    this.purpose = purpose;
  }

  /**
   * Cryptographic hash function applied to the message before computing the signature.
   */
  public io.v.v23.security.Hash getHash() {
    return this.hash;
  }

  /**
   * Cryptographic hash function applied to the message before computing the signature.
   */
  public void setHash(io.v.v23.security.Hash hash) {
    this.hash = hash;
  }

  /**
   * Pair of integers that make up an ECDSA signature.
   */
  public byte[] getR() {
    return this.r;
  }

  /**
   * Pair of integers that make up an ECDSA signature.
   */
  public void setR(byte[] r) {
    this.r = r;
  }

  public byte[] getS() {
    return this.s;
  }

  public void setS(byte[] s) {
    this.s = s;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    VSignature other = (VSignature) obj;

    if (!java.util.Arrays.equals(this.purpose, other.purpose)) {
      return false;
    }

    if (this.hash == null) {
      if (other.hash != null) {
        return false;
      }
    } else if (!this.hash.equals(other.hash)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.r, other.r)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.s, other.s)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.util.Arrays.hashCode(this.purpose);

    result = prime * result + (this.hash == null ? 0 : this.hash.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.r);

    result = prime * result + java.util.Arrays.hashCode(this.s);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "purpose:" + java.util.Arrays.toString(this.purpose);

    result += ", ";

    result += "hash:" + this.hash;

    result += ", ";

    result += "r:" + java.util.Arrays.toString(this.r);

    result += ", ";

    result += "s:" + java.util.Arrays.toString(this.s);

    return result + "}";
  }
}
