// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * Certificate represents the cryptographic proof of the binding of
 * extensions of a blessing held by one principal to another (represented by
 * a public key) under specific caveats.
 *<p>
 * For example, if a principal P1 has a blessing "alice", then it can
 * extend it with a Certificate to generate the blessing "alice/friend" for
 * another principal P2.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.Certificate")
public class VCertificate extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Extension", index = 0)
  private java.lang.String extension;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PublicKey", index = 1)
  private byte[] publicKey;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Caveats", index = 2)
  private java.util.List<io.v.v23.security.Caveat> caveats;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Signature", index = 3)
  private io.v.v23.security.VSignature signature;

  /**
   * Vdl type for {@link VCertificate}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(VCertificate.class);

  /**
   * Creates a new zero-value instance of {@link VCertificate}.
   */
  public VCertificate() {
    super(VDL_TYPE);

    this.extension = "";

    this.publicKey = new byte[] {};

    this.caveats = new java.util.ArrayList<io.v.v23.security.Caveat>();

    this.signature = new io.v.v23.security.VSignature();
  }

  /**
   * Creates a new instance of {@link VCertificate} with the provided field values.
   */
  public VCertificate(
      java.lang.String extension,
      byte[] publicKey,
      java.util.List<io.v.v23.security.Caveat> caveats,
      io.v.v23.security.VSignature signature) {
    super(VDL_TYPE);

    this.extension = extension;

    this.publicKey = publicKey;

    this.caveats = caveats;

    this.signature = signature;
  }

  /**
   * Human-readable string extension bound to PublicKey.
   */
  public java.lang.String getExtension() {
    return this.extension;
  }

  /**
   * Human-readable string extension bound to PublicKey.
   */
  public void setExtension(java.lang.String extension) {
    this.extension = extension;
  }

  /**
   * DER-encoded PKIX public key.
   */
  public byte[] getPublicKey() {
    return this.publicKey;
  }

  /**
   * DER-encoded PKIX public key.
   */
  public void setPublicKey(byte[] publicKey) {
    this.publicKey = publicKey;
  }

  /**
   * Caveats on the binding of Name to PublicKey.
   */
  public java.util.List<io.v.v23.security.Caveat> getCaveats() {
    return this.caveats;
  }

  /**
   * Caveats on the binding of Name to PublicKey.
   */
  public void setCaveats(java.util.List<io.v.v23.security.Caveat> caveats) {
    this.caveats = caveats;
  }

  /**
   * Signature by the blessing principal that binds the extension to the public key.
   */
  public io.v.v23.security.VSignature getSignature() {
    return this.signature;
  }

  /**
   * Signature by the blessing principal that binds the extension to the public key.
   */
  public void setSignature(io.v.v23.security.VSignature signature) {
    this.signature = signature;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    VCertificate other = (VCertificate) obj;

    if (this.extension == null) {
      if (other.extension != null) {
        return false;
      }
    } else if (!this.extension.equals(other.extension)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.publicKey, other.publicKey)) {
      return false;
    }

    if (this.caveats == null) {
      if (other.caveats != null) {
        return false;
      }
    } else if (!this.caveats.equals(other.caveats)) {
      return false;
    }

    if (this.signature == null) {
      if (other.signature != null) {
        return false;
      }
    } else if (!this.signature.equals(other.signature)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.extension == null ? 0 : this.extension.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.publicKey);

    result = prime * result + (this.caveats == null ? 0 : this.caveats.hashCode());

    result = prime * result + (this.signature == null ? 0 : this.signature.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "extension:" + this.extension;

    result += ", ";

    result += "publicKey:" + java.util.Arrays.toString(this.publicKey);

    result += ", ";

    result += "caveats:" + this.caveats;

    result += ", ";

    result += "signature:" + this.signature;

    return result + "}";
  }
}
