// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * ThirdPartyRequirements specifies the information required by the third-party
 * that will issue discharges for third-party caveats.
 *<p>
 * These requirements are typically used to construct a DischargeImpetus, which
 * will be sent to the third-party.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.ThirdPartyRequirements")
public class ThirdPartyRequirements extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ReportServer", index = 0)
  private boolean reportServer;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ReportMethod", index = 1)
  private boolean reportMethod;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ReportArguments", index = 2)
  private boolean reportArguments;

  /**
   * Vdl type for {@link ThirdPartyRequirements}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(ThirdPartyRequirements.class);

  /**
   * Creates a new zero-value instance of {@link ThirdPartyRequirements}.
   */
  public ThirdPartyRequirements() {
    super(VDL_TYPE);

    this.reportServer = false;

    this.reportMethod = false;

    this.reportArguments = false;
  }

  /**
   * Creates a new instance of {@link ThirdPartyRequirements} with the provided field values.
   */
  public ThirdPartyRequirements(
      boolean reportServer, boolean reportMethod, boolean reportArguments) {
    super(VDL_TYPE);

    this.reportServer = reportServer;

    this.reportMethod = reportMethod;

    this.reportArguments = reportArguments;
  }

  /**
   * The blessings presented by the server of an IPC call.
   */
  public boolean getReportServer() {
    return this.reportServer;
  }

  /**
   * The blessings presented by the server of an IPC call.
   */
  public void setReportServer(boolean reportServer) {
    this.reportServer = reportServer;
  }

  /**
   * The name of the method being invoked.
   */
  public boolean getReportMethod() {
    return this.reportMethod;
  }

  /**
   * The name of the method being invoked.
   */
  public void setReportMethod(boolean reportMethod) {
    this.reportMethod = reportMethod;
  }

  /**
   * Arguments to the method being invoked.
   */
  public boolean getReportArguments() {
    return this.reportArguments;
  }

  /**
   * Arguments to the method being invoked.
   */
  public void setReportArguments(boolean reportArguments) {
    this.reportArguments = reportArguments;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    ThirdPartyRequirements other = (ThirdPartyRequirements) obj;

    if (this.reportServer != other.reportServer) {
      return false;
    }

    if (this.reportMethod != other.reportMethod) {
      return false;
    }

    if (this.reportArguments != other.reportArguments) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.lang.Boolean.valueOf(this.reportServer).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.reportMethod).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.reportArguments).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "reportServer:" + this.reportServer;

    result += ", ";

    result += "reportMethod:" + this.reportMethod;

    result += ", ";

    result += "reportArguments:" + this.reportArguments;

    return result + "}";
  }
}
