// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: caveat.vdl
package io.v.v23.security;

/**
 * publicKeyThirdPartyCaveatParam represents a third-party caveat that requires
 * PublicKeyDischarge(s) to be issued by a principal identified by a public key.
 *<p>
 * The Id of the caveat is base64-encoded:
 * hash(hash(Nonce), hash(DischargerKey), hash(Caveats[0]), hash(Caveats[1]), ...)
 * where hash is a cryptographic hash function with a security strength
 * equivalent to that of the DischargerKey. For example, if DischargerKey
 * represents an ECDSA public key with the P384 curve, then hash should be
 * SHA384.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.publicKeyThirdPartyCaveatParam")
class PublicKeyThirdPartyCaveatParam extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Nonce", index = 0)
  private io.v.v23.security.Nonce nonce;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Caveats", index = 1)
  private java.util.List<io.v.v23.security.Caveat> caveats;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DischargerKey", index = 2)
  private byte[] dischargerKey;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DischargerLocation", index = 3)
  private java.lang.String dischargerLocation;

  @io.v.v23.vdl.GeneratedFromVdl(name = "DischargerRequirements", index = 4)
  private io.v.v23.security.ThirdPartyRequirements dischargerRequirements;

  /**
   * Vdl type for {@link PublicKeyThirdPartyCaveatParam}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(PublicKeyThirdPartyCaveatParam.class);

  /**
   * Creates a new zero-value instance of {@link PublicKeyThirdPartyCaveatParam}.
   */
  public PublicKeyThirdPartyCaveatParam() {
    super(VDL_TYPE);

    this.nonce = new io.v.v23.security.Nonce();

    this.caveats = new java.util.ArrayList<io.v.v23.security.Caveat>();

    this.dischargerKey = new byte[] {};

    this.dischargerLocation = "";

    this.dischargerRequirements = new io.v.v23.security.ThirdPartyRequirements();
  }

  /**
   * Creates a new instance of {@link PublicKeyThirdPartyCaveatParam} with the provided field values.
   */
  public PublicKeyThirdPartyCaveatParam(
      io.v.v23.security.Nonce nonce,
      java.util.List<io.v.v23.security.Caveat> caveats,
      byte[] dischargerKey,
      java.lang.String dischargerLocation,
      io.v.v23.security.ThirdPartyRequirements dischargerRequirements) {
    super(VDL_TYPE);

    this.nonce = nonce;

    this.caveats = caveats;

    this.dischargerKey = dischargerKey;

    this.dischargerLocation = dischargerLocation;

    this.dischargerRequirements = dischargerRequirements;
  }

  /**
   * Nonce specifies a cryptographically random nonce associated with an
   * instance of the caveat. This prevents discharge replays, where
   * discharges for ThirdPartyCaveats embedded in the certificates for
   * one blessing can be used for another blessing.
   *<p>
   * Whether discharge re-use is a desired or un-desired property is
   * still under debate. Till the debate is settled, we err on the side
   * of discouraging re-use.
   */
  public io.v.v23.security.Nonce getNonce() {
    return this.nonce;
  }

  /**
   * Nonce specifies a cryptographically random nonce associated with an
   * instance of the caveat. This prevents discharge replays, where
   * discharges for ThirdPartyCaveats embedded in the certificates for
   * one blessing can be used for another blessing.
   *<p>
   * Whether discharge re-use is a desired or un-desired property is
   * still under debate. Till the debate is settled, we err on the side
   * of discouraging re-use.
   */
  public void setNonce(io.v.v23.security.Nonce nonce) {
    this.nonce = nonce;
  }

  /**
   * Caveats specifies the caveats that have to be validated
   * before minting a discharge for a publicKeyCaveat.
   */
  public java.util.List<io.v.v23.security.Caveat> getCaveats() {
    return this.caveats;
  }

  /**
   * Caveats specifies the caveats that have to be validated
   * before minting a discharge for a publicKeyCaveat.
   */
  public void setCaveats(java.util.List<io.v.v23.security.Caveat> caveats) {
    this.caveats = caveats;
  }

  /**
   * DER-encoded PKIX public key of the principal that can issue discharges.
   */
  public byte[] getDischargerKey() {
    return this.dischargerKey;
  }

  /**
   * DER-encoded PKIX public key of the principal that can issue discharges.
   */
  public void setDischargerKey(byte[] dischargerKey) {
    this.dischargerKey = dischargerKey;
  }

  /**
   * Object name where the third-party that can issue discharges can be found.
   */
  public java.lang.String getDischargerLocation() {
    return this.dischargerLocation;
  }

  /**
   * Object name where the third-party that can issue discharges can be found.
   */
  public void setDischargerLocation(java.lang.String dischargerLocation) {
    this.dischargerLocation = dischargerLocation;
  }

  /**
   * Information required by the third-party in order to issue a discharge.
   */
  public io.v.v23.security.ThirdPartyRequirements getDischargerRequirements() {
    return this.dischargerRequirements;
  }

  /**
   * Information required by the third-party in order to issue a discharge.
   */
  public void setDischargerRequirements(
      io.v.v23.security.ThirdPartyRequirements dischargerRequirements) {
    this.dischargerRequirements = dischargerRequirements;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    PublicKeyThirdPartyCaveatParam other = (PublicKeyThirdPartyCaveatParam) obj;

    if (this.nonce == null) {
      if (other.nonce != null) {
        return false;
      }
    } else if (!this.nonce.equals(other.nonce)) {
      return false;
    }

    if (this.caveats == null) {
      if (other.caveats != null) {
        return false;
      }
    } else if (!this.caveats.equals(other.caveats)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.dischargerKey, other.dischargerKey)) {
      return false;
    }

    if (this.dischargerLocation == null) {
      if (other.dischargerLocation != null) {
        return false;
      }
    } else if (!this.dischargerLocation.equals(other.dischargerLocation)) {
      return false;
    }

    if (this.dischargerRequirements == null) {
      if (other.dischargerRequirements != null) {
        return false;
      }
    } else if (!this.dischargerRequirements.equals(other.dischargerRequirements)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.nonce == null ? 0 : this.nonce.hashCode());

    result = prime * result + (this.caveats == null ? 0 : this.caveats.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.dischargerKey);

    result =
        prime * result + (this.dischargerLocation == null ? 0 : this.dischargerLocation.hashCode());

    result =
        prime * result
            + (this.dischargerRequirements == null ? 0 : this.dischargerRequirements.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "nonce:" + this.nonce;

    result += ", ";

    result += "caveats:" + this.caveats;

    result += ", ";

    result += "dischargerKey:" + java.util.Arrays.toString(this.dischargerKey);

    result += ", ";

    result += "dischargerLocation:" + this.dischargerLocation;

    result += ", ";

    result += "dischargerRequirements:" + this.dischargerRequirements;

    return result + "}";
  }
}
