// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: caveat.vdl
package io.v.v23.security;

/**
 * PublicKeyDischarge represents a discharge for third party caveats that
 * require a signature from a third-party's public key.
 *<p>
 * The message digest of this structure is computed as follows:
 * hash(hash(ThirdPartyCaveatId), hash(Caveats[0]), hash(Caveats[1]), ...),
 * where hash is a cryptographic hash function with a security strength
 * equivalent to the strength of the public key of the principal issuing the
 * discharge.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.PublicKeyDischarge")
public class PublicKeyDischarge extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ThirdPartyCaveatId", index = 0)
  private java.lang.String thirdPartyCaveatId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Caveats", index = 1)
  private java.util.List<io.v.v23.security.Caveat> caveats;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Signature", index = 2)
  private io.v.v23.security.VSignature signature;

  /**
   * Vdl type for {@link PublicKeyDischarge}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(PublicKeyDischarge.class);

  /**
   * Creates a new zero-value instance of {@link PublicKeyDischarge}.
   */
  public PublicKeyDischarge() {
    super(VDL_TYPE);

    this.thirdPartyCaveatId = "";

    this.caveats = new java.util.ArrayList<io.v.v23.security.Caveat>();

    this.signature = new io.v.v23.security.VSignature();
  }

  /**
   * Creates a new instance of {@link PublicKeyDischarge} with the provided field values.
   */
  public PublicKeyDischarge(
      java.lang.String thirdPartyCaveatId,
      java.util.List<io.v.v23.security.Caveat> caveats,
      io.v.v23.security.VSignature signature) {
    super(VDL_TYPE);

    this.thirdPartyCaveatId = thirdPartyCaveatId;

    this.caveats = caveats;

    this.signature = signature;
  }

  /**
   * Id of the third party caveat for which this discharge was issued.
   */
  public java.lang.String getThirdPartyCaveatId() {
    return this.thirdPartyCaveatId;
  }

  /**
   * Id of the third party caveat for which this discharge was issued.
   */
  public void setThirdPartyCaveatId(java.lang.String thirdPartyCaveatId) {
    this.thirdPartyCaveatId = thirdPartyCaveatId;
  }

  /**
   * Caveats on the use of this discharge.
   */
  public java.util.List<io.v.v23.security.Caveat> getCaveats() {
    return this.caveats;
  }

  /**
   * Caveats on the use of this discharge.
   */
  public void setCaveats(java.util.List<io.v.v23.security.Caveat> caveats) {
    this.caveats = caveats;
  }

  /**
   * Signature of the content hash of this discharge by the discharger.
   */
  public io.v.v23.security.VSignature getSignature() {
    return this.signature;
  }

  /**
   * Signature of the content hash of this discharge by the discharger.
   */
  public void setSignature(io.v.v23.security.VSignature signature) {
    this.signature = signature;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    PublicKeyDischarge other = (PublicKeyDischarge) obj;

    if (this.thirdPartyCaveatId == null) {
      if (other.thirdPartyCaveatId != null) {
        return false;
      }
    } else if (!this.thirdPartyCaveatId.equals(other.thirdPartyCaveatId)) {
      return false;
    }

    if (this.caveats == null) {
      if (other.caveats != null) {
        return false;
      }
    } else if (!this.caveats.equals(other.caveats)) {
      return false;
    }

    if (this.signature == null) {
      if (other.signature != null) {
        return false;
      }
    } else if (!this.signature.equals(other.signature)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result =
        prime * result + (this.thirdPartyCaveatId == null ? 0 : this.thirdPartyCaveatId.hashCode());

    result = prime * result + (this.caveats == null ? 0 : this.caveats.hashCode());

    result = prime * result + (this.signature == null ? 0 : this.signature.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "thirdPartyCaveatId:" + this.thirdPartyCaveatId;

    result += ", ";

    result += "caveats:" + this.caveats;

    result += ", ";

    result += "signature:" + this.signature;

    return result + "}";
  }
}
