// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * DischargeImpetus encapsulates the motivation for a discharge being sought.
 *<p>
 * These values are reported by a principal that is requesting a Discharge for
 * a third-party caveat on one of its blessings. The third-party issues
 * discharges cannot safely assume that all these values are provided, or that
 * they are provided honestly.
 *<p>
 * Implementations of services that issue discharges are encouraged to add
 * caveats to the discharge that bind the discharge to the impetus, thereby
 * rendering the discharge unsuable for any other purpose.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.DischargeImpetus")
public class DischargeImpetus extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Server", index = 0)
  private java.util.List<io.v.v23.security.BlessingPattern> server;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Method", index = 1)
  private java.lang.String method;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Arguments", index = 2)
  private java.util.List<io.v.v23.vdl.VdlAny> arguments;

  /**
   * Vdl type for {@link DischargeImpetus}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DischargeImpetus.class);

  /**
   * Creates a new zero-value instance of {@link DischargeImpetus}.
   */
  public DischargeImpetus() {
    super(VDL_TYPE);

    this.server = new java.util.ArrayList<io.v.v23.security.BlessingPattern>();

    this.method = "";

    this.arguments = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();
  }

  /**
   * Creates a new instance of {@link DischargeImpetus} with the provided field values.
   */
  public DischargeImpetus(
      java.util.List<io.v.v23.security.BlessingPattern> server,
      java.lang.String method,
      java.util.List<io.v.v23.vdl.VdlAny> arguments) {
    super(VDL_TYPE);

    this.server = server;

    this.method = method;

    this.arguments = arguments;
  }

  /**
   * The client intends to use the discharge to communicate with a server that has a blessing matching one of the patterns in this set.
   */
  public java.util.List<io.v.v23.security.BlessingPattern> getServer() {
    return this.server;
  }

  /**
   * The client intends to use the discharge to communicate with a server that has a blessing matching one of the patterns in this set.
   */
  public void setServer(java.util.List<io.v.v23.security.BlessingPattern> server) {
    this.server = server;
  }

  /**
   * Name of the method being invoked by the client.
   */
  public java.lang.String getMethod() {
    return this.method;
  }

  /**
   * Name of the method being invoked by the client.
   */
  public void setMethod(java.lang.String method) {
    this.method = method;
  }

  /**
   * Arguments to the method invocation.
   */
  public java.util.List<io.v.v23.vdl.VdlAny> getArguments() {
    return this.arguments;
  }

  /**
   * Arguments to the method invocation.
   */
  public void setArguments(java.util.List<io.v.v23.vdl.VdlAny> arguments) {
    this.arguments = arguments;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DischargeImpetus other = (DischargeImpetus) obj;

    if (this.server == null) {
      if (other.server != null) {
        return false;
      }
    } else if (!this.server.equals(other.server)) {
      return false;
    }

    if (this.method == null) {
      if (other.method != null) {
        return false;
      }
    } else if (!this.method.equals(other.method)) {
      return false;
    }

    if (this.arguments == null) {
      if (other.arguments != null) {
        return false;
      }
    } else if (!this.arguments.equals(other.arguments)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.server == null ? 0 : this.server.hashCode());

    result = prime * result + (this.method == null ? 0 : this.method.hashCode());

    result = prime * result + (this.arguments == null ? 0 : this.arguments.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "server:" + this.server;

    result += ", ";

    result += "method:" + this.method;

    result += ", ";

    result += "arguments:" + this.arguments;

    return result + "}";
  }
}
