// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s): caveat.vdl, types.vdl
package io.v.v23.security;

/**
 * Constants defined in all VDL files in this package.
 */
public final class Constants {

  /* The following constants originate in file: caveat.vdl */

  /**
   * ConstCaveat represents a caveat that either always validates or never validates.
   */
  public static final io.v.v23.security.CaveatDescriptor CONST_CAVEAT =
      new io.v.v23.security.CaveatDescriptor(
          new io.v.v23.uniqueid.Id(), new io.v.v23.vdl.VdlTypeObject(java.lang.Boolean.class));

  /**
   * ExpiryCaveat represents a caveat that validates iff the current time is no later
   * the specified time.Time.
   */
  public static final io.v.v23.security.CaveatDescriptor EXPIRY_CAVEAT =
      new io.v.v23.security.CaveatDescriptor(
          new io.v.v23.uniqueid.Id(
              new byte[] {
                (byte) 0xa6,
                (byte) 0x4c,
                (byte) 0x2d,
                (byte) 0x1,
                (byte) 0x19,
                (byte) 0xfb,
                (byte) 0xa3,
                (byte) 0x34,
                (byte) 0x80,
                (byte) 0x71,
                (byte) 0xfe,
                (byte) 0xeb,
                (byte) 0x2f,
                (byte) 0x30,
                (byte) 0x80,
                (byte) 0
              }),
          new io.v.v23.vdl.VdlTypeObject(org.joda.time.DateTime.class));

  /**
   * MethodCaveat represents a caveat that validates iff the method being
   * invoked is included in this list. An empty list implies that the caveat is invalid.
   */
  public static final io.v.v23.security.CaveatDescriptor METHOD_CAVEAT =
      new io.v.v23.security.CaveatDescriptor(
          new io.v.v23.uniqueid.Id(
              new byte[] {
                (byte) 0x54,
                (byte) 0xa6,
                (byte) 0x76,
                (byte) 0x39,
                (byte) 0x81,
                (byte) 0x37,
                (byte) 0x18,
                (byte) 0x7e,
                (byte) 0xcd,
                (byte) 0xb2,
                (byte) 0x6d,
                (byte) 0x2d,
                (byte) 0x69,
                (byte) 0xba,
                (byte) 0,
                (byte) 0x3
              }),
          new io.v.v23.vdl.VdlTypeObject(
              new com.google.common.reflect.TypeToken<
                  java.util.List<java.lang.String>>() {}.getType()));

  public static final io.v.v23.security.CaveatDescriptor PUBLIC_KEY_THIRD_PARTY_CAVEAT =
      new io.v.v23.security.CaveatDescriptor(
          new io.v.v23.uniqueid.Id(
              new byte[] {
                (byte) 0x79,
                (byte) 0x72,
                (byte) 0xce,
                (byte) 0x17,
                (byte) 0x4a,
                (byte) 0x7b,
                (byte) 0xa9,
                (byte) 0x3f,
                (byte) 0x79,
                (byte) 0x54,
                (byte) 0x7d,
                (byte) 0x76,
                (byte) 0x9c,
                (byte) 0x91,
                (byte) 0x80,
                (byte) 0
              }),
          new io.v.v23.vdl.VdlTypeObject(io.v.v23.security.PublicKeyThirdPartyCaveatParam.class));

  /**
   * PeerBlessingsCaveat represents a caveat that validates iff the peer being communicated
   * with (local end of the call) has a blessing name matching at least one of the patterns
   * in the list. An empty list implies that the caveat is invalid.
   */
  public static final io.v.v23.security.CaveatDescriptor PEER_BLESSINGS_CAVEAT =
      new io.v.v23.security.CaveatDescriptor(
          new io.v.v23.uniqueid.Id(
              new byte[] {
                (byte) 0x5,
                (byte) 0x77,
                (byte) 0xf8,
                (byte) 0x56,
                (byte) 0x4c,
                (byte) 0x8e,
                (byte) 0x5f,
                (byte) 0xfe,
                (byte) 0xff,
                (byte) 0x8e,
                (byte) 0x2b,
                (byte) 0x1f,
                (byte) 0x4d,
                (byte) 0x6d,
                (byte) 0x80,
                (byte) 0
              }),
          new io.v.v23.vdl.VdlTypeObject(
              new com.google.common.reflect.TypeToken<
                  java.util.List<io.v.v23.security.BlessingPattern>>() {}.getType()));

  /* The following constants originate in file: types.vdl */

  /**
   * NoExtension is an optional terminator for a blessing pattern indicating that the pattern
   * cannot match any extensions of the blessing from that point onwards.
   */
  public static final io.v.v23.security.BlessingPattern NO_EXTENSION =
      new io.v.v23.security.BlessingPattern("$");

  /**
   * TODO(ataly, ashankar): The semantics of AllPrincipals breaks monotonicity in
   * AccessLists with NotIn clauses. For instance, the AccessList "In: {AllPrincipals}, NotIn: {"foo"}
   * matches the principal that presents no recognizable blessings ([]) however does not
   * match the principal that presents "foo" as the only recognizable blessings (["foo"])
   * We need to sort this out.
   * Glob pattern that matches all blessings.
   */
  public static final io.v.v23.security.BlessingPattern ALL_PRINCIPALS =
      new io.v.v23.security.BlessingPattern("...");

  /**
   * ChainSeparator joins blessing names to form a blessing chain name.
   */
  public static final java.lang.String CHAIN_SEPARATOR = ":";

  /**
   * SHA1 cryptographic hash function defined in RFC3174.
   */
  public static final io.v.v23.security.Hash SHA_1_HASH = new io.v.v23.security.Hash("SHA1");

  /**
   * SHA256 cryptographic hash function defined  in FIPS 180-4.
   */
  public static final io.v.v23.security.Hash SHA_256_HASH = new io.v.v23.security.Hash("SHA256");

  /**
   * SHA384 cryptographic hash function defined in FIPS 180-2.
   */
  public static final io.v.v23.security.Hash SHA_384_HASH = new io.v.v23.security.Hash("SHA384");

  /**
   * SHA512 cryptographic hash function defined in FIPS 180-2.
   */
  public static final io.v.v23.security.Hash SHA_512_HASH = new io.v.v23.security.Hash("SHA512");

  /**
   * Signature.Purpose used by a Principal to sign arbitrary messages.
   */
  public static final java.lang.String SIGNATURE_FOR_MESSAGE_SIGNING = "S1";

  /**
   * Signature.Purpose used by a Principal when signing Certificates for creating blessings.
   */
  public static final java.lang.String SIGNATURE_FOR_BLESSING_CERTIFICATES = "B1";

  /**
   * Signature.Purpose used by a Principal when signing discharges for public-key based third-party caveats.
   */
  public static final java.lang.String SIGNATURE_FOR_DISCHARGE = "D1";

  private Constants() {}
}
