// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * CaveatDescriptor defines an association between a caveat validation function
 * (addressed by globally unique identifier) and the data needed by the
 * validation function.
 *<p>
 * For a validator to be invoked, a validation function must be registered with
 * the validator description in the language that the function is defined in.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.CaveatDescriptor")
public class CaveatDescriptor extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.uniqueid.Id id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ParamType", index = 1)
  private io.v.v23.vdl.VdlTypeObject paramType;

  /**
   * Vdl type for {@link CaveatDescriptor}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(CaveatDescriptor.class);

  /**
   * Creates a new zero-value instance of {@link CaveatDescriptor}.
   */
  public CaveatDescriptor() {
    super(VDL_TYPE);

    this.id = new io.v.v23.uniqueid.Id();

    this.paramType = new io.v.v23.vdl.VdlTypeObject();
  }

  /**
   * Creates a new instance of {@link CaveatDescriptor} with the provided field values.
   */
  public CaveatDescriptor(io.v.v23.uniqueid.Id id, io.v.v23.vdl.VdlTypeObject paramType) {
    super(VDL_TYPE);

    this.id = id;

    this.paramType = paramType;
  }

  /**
   * The identifier of the caveat validation function.
   */
  public io.v.v23.uniqueid.Id getId() {
    return this.id;
  }

  /**
   * The identifier of the caveat validation function.
   */
  public void setId(io.v.v23.uniqueid.Id id) {
    this.id = id;
  }

  /**
   * The type of the parameter expected by the validation function.
   */
  public io.v.v23.vdl.VdlTypeObject getParamType() {
    return this.paramType;
  }

  /**
   * The type of the parameter expected by the validation function.
   */
  public void setParamType(io.v.v23.vdl.VdlTypeObject paramType) {
    this.paramType = paramType;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    CaveatDescriptor other = (CaveatDescriptor) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.paramType == null) {
      if (other.paramType != null) {
        return false;
      }
    } else if (!this.paramType.equals(other.paramType)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.paramType == null ? 0 : this.paramType.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "paramType:" + this.paramType;

    return result + "}";
  }
}
