// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.security;

/**
 * Caveat is a condition on the validity of a blessing/discharge.
 *<p>
 * These conditions are provided when asking a principal to create
 * a blessing/discharge and are verified when extracting blessings
 * (Blessings.ForName in the Go API).
 *<p>
 * Given a Hash, the message digest of a caveat is:
 * Hash(Hash(Id), Hash(ParamVom))
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/security.Caveat")
public class Caveat extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.uniqueid.Id id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ParamVom", index = 1)
  private byte[] paramVom;

  /**
   * Vdl type for {@link Caveat}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Caveat.class);

  /**
   * Creates a new zero-value instance of {@link Caveat}.
   */
  public Caveat() {
    super(VDL_TYPE);

    this.id = new io.v.v23.uniqueid.Id();

    this.paramVom = new byte[] {};
  }

  /**
   * Creates a new instance of {@link Caveat} with the provided field values.
   */
  public Caveat(io.v.v23.uniqueid.Id id, byte[] paramVom) {
    super(VDL_TYPE);

    this.id = id;

    this.paramVom = paramVom;
  }

  /**
   * The identifier of the caveat validation function.
   */
  public io.v.v23.uniqueid.Id getId() {
    return this.id;
  }

  /**
   * The identifier of the caveat validation function.
   */
  public void setId(io.v.v23.uniqueid.Id id) {
    this.id = id;
  }

  /**
   * VOM-encoded bytes of the parameters to be provided to the validation function.
   */
  public byte[] getParamVom() {
    return this.paramVom;
  }

  /**
   * VOM-encoded bytes of the parameters to be provided to the validation function.
   */
  public void setParamVom(byte[] paramVom) {
    this.paramVom = paramVom;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Caveat other = (Caveat) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.paramVom, other.paramVom)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + java.util.Arrays.hashCode(this.paramVom);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "paramVom:" + java.util.Arrays.toString(this.paramVom);

    return result + "}";
  }
}
