// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: protocol.vdl
package io.v.v23.rpc;

/**
 * Response describes the response header sent by the server to the client.  A
 * zero response header is sent before each streaming arg.  Thereafter a
 * non-zero response header is sent at the end of the RPC call, right before
 * the positional results.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/rpc.Response")
public class Response extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Error", index = 0)
  private io.v.v23.verror.VException error;

  @io.v.v23.vdl.GeneratedFromVdl(name = "EndStreamResults", index = 1)
  private boolean endStreamResults;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumPosResults", index = 2)
  private io.v.v23.vdl.VdlUint64 numPosResults;

  @io.v.v23.vdl.GeneratedFromVdl(name = "TraceResponse", index = 3)
  private io.v.v23.vtrace.Response traceResponse;

  @io.v.v23.vdl.GeneratedFromVdl(name = "AckBlessings", index = 4)
  private boolean ackBlessings;

  /**
   * Vdl type for {@link Response}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Response.class);

  /**
   * Creates a new zero-value instance of {@link Response}.
   */
  public Response() {
    super(VDL_TYPE);

    this.error = null;

    this.endStreamResults = false;

    this.numPosResults = new io.v.v23.vdl.VdlUint64();

    this.traceResponse = new io.v.v23.vtrace.Response();

    this.ackBlessings = false;
  }

  /**
   * Creates a new instance of {@link Response} with the provided field values.
   */
  public Response(
      io.v.v23.verror.VException error,
      boolean endStreamResults,
      io.v.v23.vdl.VdlUint64 numPosResults,
      io.v.v23.vtrace.Response traceResponse,
      boolean ackBlessings) {
    super(VDL_TYPE);

    this.error = error;

    this.endStreamResults = endStreamResults;

    this.numPosResults = numPosResults;

    this.traceResponse = traceResponse;

    this.ackBlessings = ackBlessings;
  }

  /**
   * Error in processing the RPC at the server. Implies EndStreamResults.
   */
  public io.v.v23.verror.VException getError() {
    return this.error;
  }

  /**
   * Error in processing the RPC at the server. Implies EndStreamResults.
   */
  public void setError(io.v.v23.verror.VException error) {
    this.error = error;
  }

  /**
   * EndStreamResults is true iff no more streaming results will be sent; the
   * remainder of the stream consists of NumPosResults positional results.
   */
  public boolean getEndStreamResults() {
    return this.endStreamResults;
  }

  /**
   * EndStreamResults is true iff no more streaming results will be sent; the
   * remainder of the stream consists of NumPosResults positional results.
   */
  public void setEndStreamResults(boolean endStreamResults) {
    this.endStreamResults = endStreamResults;
  }

  /**
   * NumPosResults is the number of positional results, which immediately follow
   * on the response stream.  After these results, no further data will be sent
   * on the response stream.
   */
  public io.v.v23.vdl.VdlUint64 getNumPosResults() {
    return this.numPosResults;
  }

  /**
   * NumPosResults is the number of positional results, which immediately follow
   * on the response stream.  After these results, no further data will be sent
   * on the response stream.
   */
  public void setNumPosResults(io.v.v23.vdl.VdlUint64 numPosResults) {
    this.numPosResults = numPosResults;
  }

  /**
   * TraceResponse maintains the vtrace context between clients and servers.
   * In some cases trace data will be included in this response as well.
   */
  public io.v.v23.vtrace.Response getTraceResponse() {
    return this.traceResponse;
  }

  /**
   * TraceResponse maintains the vtrace context between clients and servers.
   * In some cases trace data will be included in this response as well.
   */
  public void setTraceResponse(io.v.v23.vtrace.Response traceResponse) {
    this.traceResponse = traceResponse;
  }

  /**
   * AckBlessings is true if the server successfully recevied the client's
   * blessings and stored them in the server's blessings cache.
   */
  public boolean getAckBlessings() {
    return this.ackBlessings;
  }

  /**
   * AckBlessings is true if the server successfully recevied the client's
   * blessings and stored them in the server's blessings cache.
   */
  public void setAckBlessings(boolean ackBlessings) {
    this.ackBlessings = ackBlessings;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Response other = (Response) obj;

    if (this.error == null) {
      if (other.error != null) {
        return false;
      }
    } else if (!this.error.equals(other.error)) {
      return false;
    }

    if (this.endStreamResults != other.endStreamResults) {
      return false;
    }

    if (this.numPosResults == null) {
      if (other.numPosResults != null) {
        return false;
      }
    } else if (!this.numPosResults.equals(other.numPosResults)) {
      return false;
    }

    if (this.traceResponse == null) {
      if (other.traceResponse != null) {
        return false;
      }
    } else if (!this.traceResponse.equals(other.traceResponse)) {
      return false;
    }

    if (this.ackBlessings != other.ackBlessings) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.error == null ? 0 : this.error.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.endStreamResults).hashCode();

    result = prime * result + (this.numPosResults == null ? 0 : this.numPosResults.hashCode());

    result = prime * result + (this.traceResponse == null ? 0 : this.traceResponse.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.ackBlessings).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "error:" + this.error;

    result += ", ";

    result += "endStreamResults:" + this.endStreamResults;

    result += ", ";

    result += "numPosResults:" + this.numPosResults;

    result += ", ";

    result += "traceResponse:" + this.traceResponse;

    result += ", ";

    result += "ackBlessings:" + this.ackBlessings;

    return result + "}";
  }
}
