// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: protocol.vdl
package io.v.v23.rpc;

/**
 * Request describes the request header sent by the client to the server.  A
 * non-zero request header is sent at the beginning of the RPC call, followed by
 * the positional args.  Thereafter a zero request header is sent before each
 * streaming arg, terminated by a non-zero request header with EndStreamArgs set
 * to true.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/rpc.Request")
public class Request extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Suffix", index = 0)
  private java.lang.String suffix;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Method", index = 1)
  private java.lang.String method;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumPosArgs", index = 2)
  private io.v.v23.vdl.VdlUint64 numPosArgs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "EndStreamArgs", index = 3)
  private boolean endStreamArgs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Deadline", index = 4)
  private io.v.v23.vdlroot.time.WireDeadline deadline;

  @io.v.v23.vdl.GeneratedFromVdl(name = "GrantedBlessings", index = 5)
  private io.v.v23.security.Blessings grantedBlessings;

  @io.v.v23.vdl.GeneratedFromVdl(name = "TraceRequest", index = 6)
  private io.v.v23.vtrace.Request traceRequest;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Language", index = 7)
  private java.lang.String language;

  /**
   * Vdl type for {@link Request}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Request.class);

  /**
   * Creates a new zero-value instance of {@link Request}.
   */
  public Request() {
    super(VDL_TYPE);

    this.suffix = "";

    this.method = "";

    this.numPosArgs = new io.v.v23.vdl.VdlUint64();

    this.endStreamArgs = false;

    this.deadline = new io.v.v23.vdlroot.time.WireDeadline();

    this.grantedBlessings = null;

    this.traceRequest = new io.v.v23.vtrace.Request();

    this.language = "";
  }

  /**
   * Creates a new instance of {@link Request} with the provided field values.
   */
  public Request(
      java.lang.String suffix,
      java.lang.String method,
      io.v.v23.vdl.VdlUint64 numPosArgs,
      boolean endStreamArgs,
      io.v.v23.vdlroot.time.WireDeadline deadline,
      io.v.v23.security.Blessings grantedBlessings,
      io.v.v23.vtrace.Request traceRequest,
      java.lang.String language) {
    super(VDL_TYPE);

    this.suffix = suffix;

    this.method = method;

    this.numPosArgs = numPosArgs;

    this.endStreamArgs = endStreamArgs;

    this.deadline = deadline;

    this.grantedBlessings = grantedBlessings;

    this.traceRequest = traceRequest;

    this.language = language;
  }

  /**
   * Suffix of the name used to identify the object hosting the service.
   */
  public java.lang.String getSuffix() {
    return this.suffix;
  }

  /**
   * Suffix of the name used to identify the object hosting the service.
   */
  public void setSuffix(java.lang.String suffix) {
    this.suffix = suffix;
  }

  /**
   * Method to invoke on the service.
   */
  public java.lang.String getMethod() {
    return this.method;
  }

  /**
   * Method to invoke on the service.
   */
  public void setMethod(java.lang.String method) {
    this.method = method;
  }

  /**
   * NumPosArgs is the number of positional arguments, which follow this message
   * (and any blessings) on the request stream.
   */
  public io.v.v23.vdl.VdlUint64 getNumPosArgs() {
    return this.numPosArgs;
  }

  /**
   * NumPosArgs is the number of positional arguments, which follow this message
   * (and any blessings) on the request stream.
   */
  public void setNumPosArgs(io.v.v23.vdl.VdlUint64 numPosArgs) {
    this.numPosArgs = numPosArgs;
  }

  /**
   * EndStreamArgs is true iff no more streaming arguments will be sent.  No
   * more data will be sent on the request stream.
   *<p>
   * NOTE(bprosnitz): We can support multiple stream values per request (+response) header
   * efficiently by adding a NumExtraStreamArgs (+NumExtraStreamResults to response) field
   * that is the uint64 (number of stream args to send) - 1. The request is then zero when
   * exactly one streaming arg is sent. Since the request and response headers are small,
   * this is only likely necessary for frequently streaming small values.
   * See implementation in CL: 3913
   */
  public boolean getEndStreamArgs() {
    return this.endStreamArgs;
  }

  /**
   * EndStreamArgs is true iff no more streaming arguments will be sent.  No
   * more data will be sent on the request stream.
   *<p>
   * NOTE(bprosnitz): We can support multiple stream values per request (+response) header
   * efficiently by adding a NumExtraStreamArgs (+NumExtraStreamResults to response) field
   * that is the uint64 (number of stream args to send) - 1. The request is then zero when
   * exactly one streaming arg is sent. Since the request and response headers are small,
   * this is only likely necessary for frequently streaming small values.
   * See implementation in CL: 3913
   */
  public void setEndStreamArgs(boolean endStreamArgs) {
    this.endStreamArgs = endStreamArgs;
  }

  /**
   * Deadline after which the request should be cancelled.  This is a hint to
   * the server, to avoid wasted work.
   */
  public io.v.v23.vdlroot.time.WireDeadline getDeadline() {
    return this.deadline;
  }

  /**
   * Deadline after which the request should be cancelled.  This is a hint to
   * the server, to avoid wasted work.
   */
  public void setDeadline(io.v.v23.vdlroot.time.WireDeadline deadline) {
    this.deadline = deadline;
  }

  /**
   * GrantedBlessings are blessings bound to the principal running the server,
   * provided by the client.
   */
  public io.v.v23.security.Blessings getGrantedBlessings() {
    return this.grantedBlessings;
  }

  /**
   * GrantedBlessings are blessings bound to the principal running the server,
   * provided by the client.
   */
  public void setGrantedBlessings(io.v.v23.security.Blessings grantedBlessings) {
    this.grantedBlessings = grantedBlessings;
  }

  /**
   * TraceRequest maintains the vtrace context between clients and servers
   * and specifies additional parameters that control how tracing behaves.
   */
  public io.v.v23.vtrace.Request getTraceRequest() {
    return this.traceRequest;
  }

  /**
   * TraceRequest maintains the vtrace context between clients and servers
   * and specifies additional parameters that control how tracing behaves.
   */
  public void setTraceRequest(io.v.v23.vtrace.Request traceRequest) {
    this.traceRequest = traceRequest;
  }

  /**
   * Language indicates the language of the instegator of the RPC.
   * By convention it should be an IETF language tag:
   * http://en.wikipedia.org/wiki/IETF_language_tag
   */
  public java.lang.String getLanguage() {
    return this.language;
  }

  /**
   * Language indicates the language of the instegator of the RPC.
   * By convention it should be an IETF language tag:
   * http://en.wikipedia.org/wiki/IETF_language_tag
   */
  public void setLanguage(java.lang.String language) {
    this.language = language;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Request other = (Request) obj;

    if (this.suffix == null) {
      if (other.suffix != null) {
        return false;
      }
    } else if (!this.suffix.equals(other.suffix)) {
      return false;
    }

    if (this.method == null) {
      if (other.method != null) {
        return false;
      }
    } else if (!this.method.equals(other.method)) {
      return false;
    }

    if (this.numPosArgs == null) {
      if (other.numPosArgs != null) {
        return false;
      }
    } else if (!this.numPosArgs.equals(other.numPosArgs)) {
      return false;
    }

    if (this.endStreamArgs != other.endStreamArgs) {
      return false;
    }

    if (this.deadline == null) {
      if (other.deadline != null) {
        return false;
      }
    } else if (!this.deadline.equals(other.deadline)) {
      return false;
    }

    if (this.grantedBlessings == null) {
      if (other.grantedBlessings != null) {
        return false;
      }
    } else if (!this.grantedBlessings.equals(other.grantedBlessings)) {
      return false;
    }

    if (this.traceRequest == null) {
      if (other.traceRequest != null) {
        return false;
      }
    } else if (!this.traceRequest.equals(other.traceRequest)) {
      return false;
    }

    if (this.language == null) {
      if (other.language != null) {
        return false;
      }
    } else if (!this.language.equals(other.language)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.suffix == null ? 0 : this.suffix.hashCode());

    result = prime * result + (this.method == null ? 0 : this.method.hashCode());

    result = prime * result + (this.numPosArgs == null ? 0 : this.numPosArgs.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.endStreamArgs).hashCode();

    result = prime * result + (this.deadline == null ? 0 : this.deadline.hashCode());

    result =
        prime * result + (this.grantedBlessings == null ? 0 : this.grantedBlessings.hashCode());

    result = prime * result + (this.traceRequest == null ? 0 : this.traceRequest.hashCode());

    result = prime * result + (this.language == null ? 0 : this.language.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "suffix:" + this.suffix;

    result += ", ";

    result += "method:" + this.method;

    result += ", ";

    result += "numPosArgs:" + this.numPosArgs;

    result += ", ";

    result += "endStreamArgs:" + this.endStreamArgs;

    result += ", ";

    result += "deadline:" + this.deadline;

    result += ", ";

    result += "grantedBlessings:" + this.grantedBlessings;

    result += ", ";

    result += "traceRequest:" + this.traceRequest;

    result += ", ";

    result += "language:" + this.language;

    return result + "}";
  }
}
