// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.naming;

/**
 * MountEntry represents a given name mounted in the mounttable.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/naming.MountEntry")
public class MountEntry extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Name", index = 0)
  private java.lang.String name;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Servers", index = 1)
  private java.util.List<io.v.v23.naming.MountedServer> servers;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ServesMountTable", index = 2)
  private boolean servesMountTable;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsLeaf", index = 3)
  private boolean isLeaf;

  /**
   * Vdl type for {@link MountEntry}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(MountEntry.class);

  /**
   * Creates a new zero-value instance of {@link MountEntry}.
   */
  public MountEntry() {
    super(VDL_TYPE);

    this.name = "";

    this.servers = new java.util.ArrayList<io.v.v23.naming.MountedServer>();

    this.servesMountTable = false;

    this.isLeaf = false;
  }

  /**
   * Creates a new instance of {@link MountEntry} with the provided field values.
   */
  public MountEntry(
      java.lang.String name,
      java.util.List<io.v.v23.naming.MountedServer> servers,
      boolean servesMountTable,
      boolean isLeaf) {
    super(VDL_TYPE);

    this.name = name;

    this.servers = servers;

    this.servesMountTable = servesMountTable;

    this.isLeaf = isLeaf;
  }

  /**
   * Name is the mounted name.
   */
  public java.lang.String getName() {
    return this.name;
  }

  /**
   * Name is the mounted name.
   */
  public void setName(java.lang.String name) {
    this.name = name;
  }

  /**
   * Servers (if present) specifies the mounted names.
   */
  public java.util.List<io.v.v23.naming.MountedServer> getServers() {
    return this.servers;
  }

  /**
   * Servers (if present) specifies the mounted names.
   */
  public void setServers(java.util.List<io.v.v23.naming.MountedServer> servers) {
    this.servers = servers;
  }

  /**
   * ServesMountTable is true if the servers represent mount tables.
   */
  public boolean getServesMountTable() {
    return this.servesMountTable;
  }

  /**
   * ServesMountTable is true if the servers represent mount tables.
   */
  public void setServesMountTable(boolean servesMountTable) {
    this.servesMountTable = servesMountTable;
  }

  /**
   * IsLeaf is true if this entry represents a leaf object.
   */
  public boolean getIsLeaf() {
    return this.isLeaf;
  }

  /**
   * IsLeaf is true if this entry represents a leaf object.
   */
  public void setIsLeaf(boolean isLeaf) {
    this.isLeaf = isLeaf;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    MountEntry other = (MountEntry) obj;

    if (this.name == null) {
      if (other.name != null) {
        return false;
      }
    } else if (!this.name.equals(other.name)) {
      return false;
    }

    if (this.servers == null) {
      if (other.servers != null) {
        return false;
      }
    } else if (!this.servers.equals(other.servers)) {
      return false;
    }

    if (this.servesMountTable != other.servesMountTable) {
      return false;
    }

    if (this.isLeaf != other.isLeaf) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.name == null ? 0 : this.name.hashCode());

    result = prime * result + (this.servers == null ? 0 : this.servers.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.servesMountTable).hashCode();

    result = prime * result + java.lang.Boolean.valueOf(this.isLeaf).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "name:" + this.name;

    result += ", ";

    result += "servers:" + this.servers;

    result += ", ";

    result += "servesMountTable:" + this.servesMountTable;

    result += ", ";

    result += "isLeaf:" + this.isLeaf;

    return result + "}";
  }
}
