// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.v23.discovery;

/**
 * Advertisement represents a feed into advertiser to broadcast its contents
 * to scanners.
 *<p>
 * A large advertisement may require additional RPC calls causing delay in
 * discovery. We limit the maximum size of an advertisement to 512 bytes
 * excluding id and attachments.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/v23/discovery.Advertisement")
public class Advertisement extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Id", index = 0)
  private io.v.v23.discovery.AdId id;

  @io.v.v23.vdl.GeneratedFromVdl(name = "InterfaceName", index = 1)
  private java.lang.String interfaceName;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Addresses", index = 2)
  private java.util.List<java.lang.String> addresses;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Attributes", index = 3)
  private io.v.v23.discovery.Attributes attributes;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Attachments", index = 4)
  private io.v.v23.discovery.Attachments attachments;

  /**
   * Vdl type for {@link Advertisement}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(Advertisement.class);

  /**
   * Creates a new zero-value instance of {@link Advertisement}.
   */
  public Advertisement() {
    super(VDL_TYPE);

    this.id = new io.v.v23.discovery.AdId();

    this.interfaceName = "";

    this.addresses = new java.util.ArrayList<java.lang.String>();

    this.attributes = new io.v.v23.discovery.Attributes();

    this.attachments = new io.v.v23.discovery.Attachments();
  }

  /**
   * Creates a new instance of {@link Advertisement} with the provided field values.
   */
  public Advertisement(
      io.v.v23.discovery.AdId id,
      java.lang.String interfaceName,
      java.util.List<java.lang.String> addresses,
      io.v.v23.discovery.Attributes attributes,
      io.v.v23.discovery.Attachments attachments) {
    super(VDL_TYPE);

    this.id = id;

    this.interfaceName = interfaceName;

    this.addresses = addresses;

    this.attributes = attributes;

    this.attachments = attachments;
  }

  /**
   * Universal unique identifier of the advertisement.
   * If this is not specified, a random unique identifier will be assigned.
   */
  public io.v.v23.discovery.AdId getId() {
    return this.id;
  }

  /**
   * Universal unique identifier of the advertisement.
   * If this is not specified, a random unique identifier will be assigned.
   */
  public void setId(io.v.v23.discovery.AdId id) {
    this.id = id;
  }

  /**
   * Interface name that the advertised service implements.
   * E.g., 'v.io/v23/services/vtrace.Store'.
   */
  public java.lang.String getInterfaceName() {
    return this.interfaceName;
  }

  /**
   * Interface name that the advertised service implements.
   * E.g., 'v.io/v23/services/vtrace.Store'.
   */
  public void setInterfaceName(java.lang.String interfaceName) {
    this.interfaceName = interfaceName;
  }

  /**
   * Addresses (vanadium object names) that the advertised service is served on.
   * E.g., '/host:port/a/b/c', '/ns.dev.v.io:8101/blah/blah'.
   */
  public java.util.List<java.lang.String> getAddresses() {
    return this.addresses;
  }

  /**
   * Addresses (vanadium object names) that the advertised service is served on.
   * E.g., '/host:port/a/b/c', '/ns.dev.v.io:8101/blah/blah'.
   */
  public void setAddresses(java.util.List<java.lang.String> addresses) {
    this.addresses = addresses;
  }

  /**
   * Attributes as a key/value pair.
   * E.g., {'resolution': '1024x768'}.
   *<p>
   * The key must be US-ASCII printable characters, excluding the '=' character
   * and should not start with '_' character.
   *<p>
   * We limit the maximum number of attachments to 32.
   */
  public io.v.v23.discovery.Attributes getAttributes() {
    return this.attributes;
  }

  /**
   * Attributes as a key/value pair.
   * E.g., {'resolution': '1024x768'}.
   *<p>
   * The key must be US-ASCII printable characters, excluding the '=' character
   * and should not start with '_' character.
   *<p>
   * We limit the maximum number of attachments to 32.
   */
  public void setAttributes(io.v.v23.discovery.Attributes attributes) {
    this.attributes = attributes;
  }

  /**
   * Attachments as a key/value pair.
   * E.g., {'thumbnail': binary_data }.
   *<p>
   * Unlike attributes, attachments are for binary data and they are not queryable.
   *<p>
   * The key must be US-ASCII printable characters, excluding the '=' character
   * and should not start with '_' character.
   *<p>
   * We limit the maximum number of attachments to 32 and the maximum size of each
   * attachment is 4K bytes.
   */
  public io.v.v23.discovery.Attachments getAttachments() {
    return this.attachments;
  }

  /**
   * Attachments as a key/value pair.
   * E.g., {'thumbnail': binary_data }.
   *<p>
   * Unlike attributes, attachments are for binary data and they are not queryable.
   *<p>
   * The key must be US-ASCII printable characters, excluding the '=' character
   * and should not start with '_' character.
   *<p>
   * We limit the maximum number of attachments to 32 and the maximum size of each
   * attachment is 4K bytes.
   */
  public void setAttachments(io.v.v23.discovery.Attachments attachments) {
    this.attachments = attachments;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    Advertisement other = (Advertisement) obj;

    if (this.id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!this.id.equals(other.id)) {
      return false;
    }

    if (this.interfaceName == null) {
      if (other.interfaceName != null) {
        return false;
      }
    } else if (!this.interfaceName.equals(other.interfaceName)) {
      return false;
    }

    if (this.addresses == null) {
      if (other.addresses != null) {
        return false;
      }
    } else if (!this.addresses.equals(other.addresses)) {
      return false;
    }

    if (this.attributes == null) {
      if (other.attributes != null) {
        return false;
      }
    } else if (!this.attributes.equals(other.attributes)) {
      return false;
    }

    if (this.attachments == null) {
      if (other.attachments != null) {
        return false;
      }
    } else if (!this.attachments.equals(other.attachments)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.id == null ? 0 : this.id.hashCode());

    result = prime * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());

    result = prime * result + (this.addresses == null ? 0 : this.addresses.hashCode());

    result = prime * result + (this.attributes == null ? 0 : this.attributes.hashCode());

    result = prime * result + (this.attachments == null ? 0 : this.attachments.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "id:" + this.id;

    result += ", ";

    result += "interfaceName:" + this.interfaceName;

    result += ", ";

    result += "addresses:" + this.addresses;

    result += ", ";

    result += "attributes:" + this.attributes;

    result += ", ";

    result += "attachments:" + this.attachments;

    return result + "}";
  }
}
