/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.v23;

import android.content.Context;
import android.content.Intent;
import com.google.common.base.Preconditions;
import io.v.android.impl.google.services.gcm.GcmRegistrationService;
import io.v.android.v23.KeyStoreUtil;
import io.v.android.v23.UiThreadExecutor;
import io.v.v23.Options;
import io.v.v23.context.VContext;
import io.v.v23.security.BlessingStore;
import io.v.v23.security.Blessings;
import io.v.v23.security.Caveat;
import io.v.v23.security.Constants;
import io.v.v23.security.VPrincipal;
import io.v.v23.security.VSecurity;
import io.v.v23.security.VSigner;
import io.v.v23.verror.VException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.concurrent.Executor;

public class V
extends io.v.v23.V {
    private static volatile VContext globalContext;

    private static native void nativeInitGlobalAndroid(Options var0) throws VException;

    private static VContext initGlobalAndroid(VContext ctx, Options opts) {
        try {
            V.nativeInitGlobalAndroid(opts);
            return V.withExecutor((VContext)ctx, (Executor)UiThreadExecutor.INSTANCE);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't initialize global Android state", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VContext initGlobal(Context androidCtx, Options opts) {
        if (globalContext != null) {
            return globalContext;
        }
        Class<V> clazz = V.class;
        synchronized (V.class) {
            if (globalContext != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return globalContext;
            }
            if (opts == null) {
                opts = new Options();
            }
            VContext ctx = V.initGlobalShared((Options)opts);
            ctx = V.initGlobalAndroid(ctx, opts);
            ctx = VException.contextWithComponentName((VContext)ctx, (String)androidCtx.getPackageName());
            try {
                ctx = V.withPrincipal((VContext)ctx, (VPrincipal)V.createPrincipal(androidCtx));
            }
            catch (VException e) {
                throw new RuntimeException("Couldn't setup Vanadium principal", e);
            }
            globalContext = ctx;
            Intent intent = new Intent(androidCtx, GcmRegistrationService.class);
            androidCtx.startService(intent);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ctx;
        }
    }

    private static VContext initAndroidLocal(VContext ctx, Context androidCtx, Options opts) {
        return ctx.withValue((Object)new AndroidContextKey(), (Object)androidCtx);
    }

    public static VContext init(Context androidCtx, Options opts) {
        Preconditions.checkArgument((androidCtx != null ? 1 : 0) != 0);
        VContext ctx = V.initGlobal(androidCtx, opts);
        ctx = V.initAndroidLocal(ctx, androidCtx, opts);
        return ctx.withCancel();
    }

    public static VContext init(Context androidCtx) {
        return V.init(androidCtx, null);
    }

    @Deprecated
    public static VContext init() {
        throw new RuntimeException("Must call Android init with a context.");
    }

    private static VPrincipal createPrincipal(Context ctx) throws VException {
        VSigner signer;
        VPrincipal principal;
        BlessingStore store;
        KeyStore.PrivateKeyEntry keyEntry = KeyStoreUtil.getKeyStorePrivateKey(ctx.getPackageName());
        if (keyEntry == null) {
            keyEntry = KeyStoreUtil.genKeyStorePrivateKey(ctx, ctx.getPackageName());
        }
        if ((store = (principal = VSecurity.newPersistentPrincipal((VSigner)(signer = VSecurity.newSigner((PrivateKey)keyEntry.getPrivateKey(), (ECPublicKey)((ECPublicKey)keyEntry.getCertificate().getPublicKey()))), (String)ctx.getFilesDir().getAbsolutePath())).blessingStore()).peerBlessings().isEmpty()) {
            Blessings self = principal.blessSelf(ctx.getPackageName(), new Caveat[0]);
            store.setDefaultBlessings(self);
            store.set(self, Constants.ALL_PRINCIPALS);
            VSecurity.addToRoots((VPrincipal)principal, (Blessings)self);
        }
        return principal;
    }

    public static Context getAndroidContext(VContext ctx) {
        return (Context)ctx.value((Object)new AndroidContextKey());
    }

    private V() {
    }

    private static class AndroidContextKey {
        private AndroidContextKey() {
        }

        public int hashCode() {
            return 0;
        }
    }
}

