/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.v23;

import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import io.v.v23.verror.VException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;

public class KeyStoreUtil {
    private static final String KEYSTORE = "AndroidKeyStore";
    private static final String PK_ALGORITHM = "EC";
    private static final int KEY_SIZE = 256;

    public static KeyStore.PrivateKeyEntry genKeyStorePrivateKey(Context ctx, String alias) throws VException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", KEYSTORE);
            Calendar notBefore = Calendar.getInstance();
            Calendar notAfter = Calendar.getInstance();
            notAfter.add(1, 1);
            KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(ctx).setAlias(alias).setKeyType(PK_ALGORITHM).setKeySize(256).setSubject(new X500Principal(String.format("CN=%s, OU=%s", alias, ctx.getPackageName()))).setSerialNumber(BigInteger.ONE).setStartDate(notBefore.getTime()).setEndDate(notAfter.getTime()).build();
            keyGen.initialize((AlgorithmParameterSpec)spec);
            keyGen.generateKeyPair();
            return KeyStoreUtil.getKeyStorePrivateKey(alias);
        }
        catch (NoSuchProviderException e) {
            throw new VException("Couldn't find Android KeyStore");
        }
        catch (NoSuchAlgorithmException e) {
            throw new VException("Keystore doesn't support EC algorithm: " + e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new VException("Invalid keystore algorithm parameters: " + e.getMessage());
        }
    }

    public static KeyStore.PrivateKeyEntry getKeyStorePrivateKey(String alias) throws VException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE);
            keyStore.load(null);
            KeyStore.Entry entry = keyStore.getEntry(alias, null);
            if (entry == null) {
                return null;
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                throw new VException("Entry " + alias + " exists but not a private key entry.");
            }
            return (KeyStore.PrivateKeyEntry)entry;
        }
        catch (KeyStoreException e) {
            throw new VException("KeyStore not initialized: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new VException("KeyStore doesn't support the algorithm: " + e.getMessage());
        }
        catch (IOException e) {
            throw new VException("Error loading keystore: " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new VException("Error loading keystore certificates: " + e.getMessage());
        }
        catch (UnrecoverableEntryException e) {
            throw new VException("Couldn't get keystore entry: " + e.getMessage());
        }
    }

    private KeyStoreUtil() {
    }
}

