/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.libs.security;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.util.Log;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.v.android.impl.google.services.blessing.BlessingActivity;
import io.v.android.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.security.Blessings;
import io.v.v23.security.Constants;
import io.v.v23.security.VPrincipal;
import io.v.v23.security.VSecurity;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.io.Serializable;
import java.security.interfaces.ECPublicKey;
import java.util.UUID;

public class BlessingsManager
extends Fragment {
    private static String TAG = "BlessingsManager";
    private static final int REQUEST_CODE_MINT_BLESSINGS = 1000;
    private static final String STATE_SAVED = "STATE_SAVED";
    private static SettableFuture<Blessings> mintFuture;
    private VContext mBaseContext;
    private boolean mWasDestroyed = false;
    private String mPrefKey;
    private String mGoogleAccount;

    public static ListenableFuture<Blessings> getBlessings(VContext context, Activity activity, String key, boolean setAsDefault) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return Futures.immediateFailedFuture((Throwable)new VException("getBlessings() must be invoked on the UI thread"));
        }
        try {
            Blessings blessings = BlessingsManager.readBlessings(context, (Context)activity, key, setAsDefault);
            if (blessings != null) {
                return Futures.immediateFuture((Object)blessings);
            }
        }
        catch (VException e) {
            Log.e((String)TAG, (String)("Malformed blessings in SharedPreferences. Minting new blessings: " + e.getMessage()));
        }
        return BlessingsManager.mintBlessings(context, activity, key, setAsDefault);
    }

    public static Blessings readBlessings(VContext context, Context androidContext, String key, boolean setAsDefault) throws VException {
        String blessingsVom = PreferenceManager.getDefaultSharedPreferences((Context)androidContext).getString(key, "");
        if (blessingsVom == null || blessingsVom.isEmpty()) {
            return null;
        }
        Blessings blessings = (Blessings)VomUtil.decodeFromString((String)blessingsVom, Blessings.class);
        if (blessings == null) {
            throw new VException("Couldn't decode blessings: got null blessings");
        }
        return setAsDefault ? (Blessings)VFutures.sync(BlessingsManager.wrapWithSetAsDefault(context, androidContext, (ListenableFuture<Blessings>)Futures.immediateFuture((Object)blessings))) : blessings;
    }

    public static ListenableFuture<Blessings> mintBlessings(VContext ctx, Activity activity, String key, String googleAccount, boolean setAsDefault) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return Futures.immediateFailedFuture((Throwable)new VException("mintBlessings() must be invoked on the UI thread"));
        }
        if (mintFuture != null) {
            mintFuture = SettableFuture.create();
            return setAsDefault ? BlessingsManager.wrapWithSetAsDefault(ctx, (Context)activity, mintFuture) : mintFuture;
        }
        mintFuture = SettableFuture.create();
        FragmentTransaction transaction = activity.getFragmentManager().beginTransaction();
        BlessingsManager fragment = new BlessingsManager();
        fragment.mPrefKey = key;
        fragment.mGoogleAccount = googleAccount;
        transaction.add((Fragment)fragment, UUID.randomUUID().toString());
        transaction.commit();
        return setAsDefault ? BlessingsManager.wrapWithSetAsDefault(ctx, (Context)activity, mintFuture) : mintFuture;
    }

    public static ListenableFuture<Blessings> mintBlessings(VContext ctx, Activity activity, String key, boolean setAsDefault) {
        return BlessingsManager.mintBlessings(ctx, activity, key, "", setAsDefault);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mBaseContext = V.init((Context)this.getActivity());
        boolean bl = this.mWasDestroyed = savedInstanceState != null;
        if (!this.mWasDestroyed) {
            ECPublicKey pubKey = V.getPrincipal((VContext)this.mBaseContext).publicKey();
            Intent intent = new Intent((Context)this.getActivity(), BlessingActivity.class);
            intent.putExtra("PUBLIC_KEY", (Serializable)pubKey);
            if (this.mGoogleAccount != null && !this.mGoogleAccount.isEmpty()) {
                intent.putExtra("GOOGLE_ACCOUNT", this.mGoogleAccount);
            }
            intent.putExtra("PREF_KEY", this.mPrefKey);
            this.startActivityForResult(intent, 1000);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mBaseContext.cancel();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);
        savedInstanceState.putBoolean(STATE_SAVED, true);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1000: {
                if (mintFuture == null) break;
                SettableFuture<Blessings> future = mintFuture;
                mintFuture = null;
                if (data == null) {
                    future.setException((Throwable)new VException("NULL blessing response"));
                    break;
                }
                if (resultCode != -1) {
                    future.setException((Throwable)new VException("Error getting blessing: " + data.getStringExtra("ERROR")));
                    break;
                }
                byte[] blessingsVom = data.getByteArrayExtra("REPLY");
                if (blessingsVom == null || blessingsVom.length <= 0) {
                    future.setException((Throwable)new VException("Got null blessings."));
                    break;
                }
                try {
                    Blessings blessings = (Blessings)VomUtil.decode((byte[])blessingsVom, Blessings.class);
                    future.set((Object)blessings);
                }
                catch (VException e) {
                    future.setException((Throwable)e);
                }
                break;
            }
        }
        FragmentTransaction transaction = this.getActivity().getFragmentManager().beginTransaction();
        transaction.remove((Fragment)this);
        transaction.commit();
        super.onActivityResult(requestCode, resultCode, data);
    }

    private static ListenableFuture<Blessings> wrapWithSetAsDefault(final VContext ctx, Context context, ListenableFuture<Blessings> future) {
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<Blessings, Blessings>(){

            public ListenableFuture<Blessings> apply(Blessings blessings) throws Exception {
                if (ctx.isCanceled()) {
                    return Futures.immediateFailedFuture((Throwable)new VException("Vanadium context canceled"));
                }
                try {
                    VPrincipal p = V.getPrincipal((VContext)ctx);
                    p.blessingStore().setDefaultBlessings(blessings);
                    p.blessingStore().set(blessings, Constants.ALL_PRINCIPALS);
                    VSecurity.addToRoots((VPrincipal)p, (Blessings)blessings);
                    return Futures.immediateFuture((Object)blessings);
                }
                catch (VException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }
        });
    }
}

