/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.libs.inspectors;

import android.util.Base64;
import android.util.Log;
import com.google.common.collect.ImmutableList;
import io.v.android.libs.inspectors.InspectedServer;
import io.v.android.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.naming.Endpoint;
import io.v.v23.rpc.ListenSpec;
import io.v.v23.security.Authorizer;
import io.v.v23.security.Blessings;
import io.v.v23.security.Caveat;
import io.v.v23.security.CaveatDescriptor;
import io.v.v23.security.VPrincipal;
import io.v.v23.security.VSecurity;
import io.v.v23.security.VSigner;
import io.v.v23.security.access.Constants;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;

public class RemoteInspectors {
    private static final String TAG = "RemoteInspectors";
    private static final int BASE64_FLAGS = 10;
    private VContext mCtx;
    private String mMountedName;

    public RemoteInspectors(VContext ctx) throws VException {
        this.mCtx = ctx.withCancel();
        try {
            this.mMountedName = RemoteInspectors.createMountedName(ctx);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VException("Unable to create mounted name:" + e);
        }
        Log.i((String)TAG, (String)("Application state should be inspectable via: " + this.mMountedName));
        this.mCtx = V.withNewServer((VContext)V.withListenSpec((VContext)this.mCtx, (ListenSpec)new ListenSpec("tcp", ":0").withProxy("proxy")), (String)this.mMountedName, (Object)new InspectedServer(){}, (Authorizer)VSecurity.newDefaultAuthorizer());
    }

    public synchronized String invite(String invitee, ReadableDuration duration) throws VException {
        VPrincipal delegate;
        String privateKey;
        if (this.mCtx == null) {
            throw new VException("RemoteInspectors.stop already called");
        }
        ImmutableList tags = ImmutableList.of((Object)Constants.DEBUG, (Object)Constants.RESOLVE);
        Caveat debugOnly = VSecurity.newCaveat((CaveatDescriptor)Constants.ACCESS_TAG_CAVEAT, (Object)tags);
        Caveat expiration = VSecurity.newExpiryCaveat((DateTime)DateTime.now().plus(duration));
        try {
            KeyPairGenerator e = KeyPairGenerator.getInstance("EC");
            e.initialize(256);
            KeyPair keyPair = e.generateKeyPair();
            privateKey = Base64.encodeToString((byte[])keyPair.getPrivate().getEncoded(), (int)10);
            delegate = VSecurity.newPrincipal((VSigner)VSecurity.newSigner((PrivateKey)keyPair.getPrivate(), (ECPublicKey)((ECPublicKey)keyPair.getPublic())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new VException("Could not mint private key: " + e.getMessage());
        }
        VPrincipal me = V.getPrincipal((VContext)this.mCtx);
        Blessings b = me.bless(delegate.publicKey(), me.blessingStore().defaultBlessings(), "debugger:" + invitee, debugOnly, new Caveat[]{expiration});
        StringBuilder builder = new StringBuilder().append("Please inspect my application using:").append('\n').append('\n').append("debug browse").append(" --key=").append(privateKey).append(" --blessings=").append(Base64.encodeToString((byte[])VomUtil.encode((Object)b, b.getClass()), (int)10)).append(" ");
        if (this.mMountedName.length() > 0) {
            builder.append(this.mMountedName).append(" ");
        }
        for (Endpoint ep : V.getServer((VContext)this.mCtx).getStatus().getEndpoints()) {
            builder.append(ep.name()).append(" ");
        }
        return builder.toString();
    }

    private static String createMountedName(VContext ctx) throws NoSuchAlgorithmException {
        VPrincipal p = V.getPrincipal((VContext)ctx);
        String[] myNames = VSecurity.getBlessingNames((VPrincipal)p, (Blessings)p.blessingStore().defaultBlessings());
        String uid = Base64.encodeToString((byte[])MessageDigest.getInstance("SHA-256").digest(p.publicKey().getEncoded()), (int)10);
        for (String n : myNames) {
            String[] parts = n.split(":");
            if (parts.length >= 3 && parts[1].equals("u")) {
                return "users/" + parts[2] + "debug/" + uid;
            }
            if (parts.length < 4 || !parts[1].equals("o")) continue;
            return "tmp/debug/" + uid;
        }
        return "";
    }
}

