/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.services.gcm;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import io.v.v23.verror.VException;
import java.util.ArrayList;
import java.util.List;

class Util {
    static void wakeupServices(Context context, boolean restart) throws VException {
        for (ServiceInfo service : Util.getWakeableServices(context)) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(service.packageName, service.name));
            if (restart) {
                context.stopService(intent);
            }
            context.startService(intent);
        }
    }

    static List<ServiceInfo> getWakeableServices(Context context) throws VException {
        try {
            ServiceInfo[] services = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)132).services;
            if (services == null) {
                throw new VException("Couldn't get services information for package: " + context.getPackageName());
            }
            ArrayList<ServiceInfo> ret = new ArrayList<ServiceInfo>();
            for (ServiceInfo service : services) {
                boolean wakeup;
                if (service == null || !service.packageName.equals(context.getPackageName()) || service.metaData == null || !(wakeup = service.metaData.getBoolean("wakeup", false))) continue;
                ret.add(service);
            }
            return ret;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new VException(String.format("Couldn't get package information for package %s: %s", context.getPackageName(), e.getMessage()));
        }
    }

    public static boolean isServiceWakeable(Context context) throws VException {
        if (!(context instanceof Service)) {
            return false;
        }
        Service service = (Service)context;
        try {
            ServiceInfo info = service.getPackageManager().getServiceInfo(new ComponentName((Context)service, service.getClass()), 128);
            if (info.metaData == null) {
                return false;
            }
            return info.metaData.getBoolean("wakeup", false);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new VException(e.getMessage());
        }
    }

    private Util() {
    }
}

