/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.services.gcm;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import io.v.android.impl.google.services.gcm.Util;
import io.v.v23.verror.VException;
import java.io.IOException;

public class GcmRegistrationService
extends IntentService {
    private static final String TAG = "GcmRegistrationService";
    public static final String GCM_TOKEN_PREF_KEY = "io.v.android.impl.google.services.gcm.TOKEN";
    static final String EXTRA_RESTART_SERVICES = "RESTART_SERVICES";

    public GcmRegistrationService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)this);
            String token = instanceID.getToken("*", "GCM");
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this).edit();
            editor.putString(GCM_TOKEN_PREF_KEY, token);
            editor.commit();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Couldn't fetch GCM registration token: ", (Throwable)e);
        }
        boolean restartServices = intent.getBooleanExtra(EXTRA_RESTART_SERVICES, false);
        try {
            Util.wakeupServices((Context)this, restartServices);
        }
        catch (VException e) {
            Log.e((String)TAG, (String)"Couldn't wakeup services.", (Throwable)e);
        }
    }
}

