/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.services.blessing;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Log;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.v.android.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.security.Caveat;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.interfaces.ECPublicKey;

public class BlessingActivity
extends Activity
implements ActivityCompat.OnRequestPermissionsResultCallback {
    public static final String TAG = "BlessingActivity";
    private static final int REQUEST_CODE_USER_APPROVAL = 1000;
    private static final int REQUEST_CODE_PICK_ACCOUNT = 1001;
    private static final String STATE_GOOGLE_ACCOUNT = "STATE_GOOGLE_ACCOUNT";
    private static final String STATE_PUBLIC_KEY = "STATE_PUBLIC_KEY";
    private static final String STATE_PREF_KEY = "STATE_PREF_KEY";
    private static final String OAUTH_PROFILE = "https://www.googleapis.com/auth/userinfo.email";
    private static final String OAUTH_SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.email";
    private static final int BASE64_FLAGS = 10;
    public static final String EXTRA_PUBLIC_KEY = "PUBLIC_KEY";
    public static final String EXTRA_GOOGLE_ACCOUNT = "GOOGLE_ACCOUNT";
    public static final String EXTRA_PREF_KEY = "PREF_KEY";
    public static final String EXTRA_REPLY = "REPLY";
    public static final String EXTRA_ERROR = "ERROR";
    private VContext mBaseContext;
    private String mGoogleAccount = "";
    private ECPublicKey mPublicKey = null;
    private String mPrefKey = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mBaseContext = V.init((Context)this);
        this.setFinishOnTouchOutside(false);
        if (savedInstanceState != null) {
            this.mGoogleAccount = savedInstanceState.getString(STATE_GOOGLE_ACCOUNT);
            this.mPublicKey = (ECPublicKey)savedInstanceState.getSerializable(STATE_PUBLIC_KEY);
            this.mPrefKey = savedInstanceState.getString(STATE_PREF_KEY);
            return;
        }
        Intent intent = this.getIntent();
        if (intent == null) {
            this.replyWithError("Intent not found.");
            return;
        }
        this.mPublicKey = (ECPublicKey)intent.getSerializableExtra(EXTRA_PUBLIC_KEY);
        if (this.mPublicKey == null) {
            this.replyWithError("Empty blesee public key.");
            return;
        }
        if (intent.hasExtra(EXTRA_PREF_KEY)) {
            this.mPrefKey = intent.getStringExtra(EXTRA_PREF_KEY);
        }
        this.mGoogleAccount = intent.getStringExtra(EXTRA_GOOGLE_ACCOUNT);
        if (this.mGoogleAccount == null || this.mGoogleAccount.isEmpty()) {
            Intent accountIntent = AccountManager.newChooseAccountIntent(null, null, (String[])new String[]{"com.google"}, (boolean)false, null, null, null, null);
            this.startActivityForResult(accountIntent, 1001);
            return;
        }
        this.getBlessing();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mBaseContext.cancel();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString(STATE_GOOGLE_ACCOUNT, this.mGoogleAccount);
        savedInstanceState.putSerializable(STATE_PUBLIC_KEY, (Serializable)this.mPublicKey);
        savedInstanceState.putString(STATE_PREF_KEY, this.mPrefKey);
        super.onSaveInstanceState(savedInstanceState);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1001: {
                if (resultCode != -1) {
                    this.replyWithError("User didn't pick account.");
                    return;
                }
                this.mGoogleAccount = data.getStringExtra("authAccount");
                if (this.mGoogleAccount == null || this.mGoogleAccount.isEmpty()) {
                    this.replyWithError("Empty Google email.");
                    return;
                }
                this.getBlessing();
                break;
            }
            case 1000: {
                if (resultCode != -1) {
                    this.replyWithError("User didn't give proposed permissions.");
                    return;
                }
                this.getBlessing();
                break;
            }
            default: {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permission2, int[] grantResults) {
        switch (requestCode) {
            case 1000: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.getBlessing();
                    return;
                }
                this.replyWithError("User didn't give proposed permissions.");
            }
        }
    }

    private void getBlessing() {
        int permissionCheck = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.GET_ACCOUNTS");
        if (permissionCheck == -1) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.GET_ACCOUNTS"}, (int)1000);
            return;
        }
        Account[] accounts = AccountManager.get((Context)this).getAccountsByType("com.google");
        Account account = null;
        for (int i = 0; i < accounts.length; ++i) {
            if (!accounts[i].name.equals(this.mGoogleAccount)) continue;
            account = accounts[i];
        }
        if (account == null) {
            this.replyWithError("Couldn't find Google account with name: " + this.mGoogleAccount);
            return;
        }
        AccountManager.get((Context)this).getAuthToken(account, OAUTH_SCOPE, new Bundle(), false, (AccountManagerCallback)new OnTokenAcquired(), new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                BlessingActivity.this.replyWithError("Error getting auth token: " + msg.toString());
                return true;
            }
        }));
    }

    private void updatePrefs(String key, String value) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this).edit();
        editor.putString(key, value);
        editor.commit();
    }

    private void replyWithError(String error) {
        Preconditions.checkArgument((error != null && !error.isEmpty() ? 1 : 0) != 0);
        Log.e((String)TAG, (String)("Error while blessing: " + error));
        Intent intent = new Intent();
        intent.putExtra(EXTRA_ERROR, error);
        this.setResult(0, intent);
        this.finish();
    }

    private void replyWithSuccess(byte[] blessingVom) {
        Preconditions.checkArgument((blessingVom != null && blessingVom.length > 0 ? 1 : 0) != 0);
        if (!this.mPrefKey.isEmpty()) {
            String hexBlessingsVom = VomUtil.bytesToHexString((byte[])blessingVom);
            this.updatePrefs(this.mPrefKey, hexBlessingsVom);
        }
        Intent intent = new Intent();
        intent.putExtra(EXTRA_REPLY, blessingVom);
        this.setResult(-1, intent);
        this.finish();
    }

    private class BlessingFetcher
    extends AsyncTask<String, Void, byte[]> {
        ProgressDialog progressDialog;
        String errorMsg;

        private BlessingFetcher() {
            this.progressDialog = new ProgressDialog((Context)BlessingActivity.this);
            this.errorMsg = null;
        }

        protected void onPreExecute() {
            this.progressDialog.setMessage((CharSequence)"Fetching Vanadium Blessing...");
            this.progressDialog.show();
        }

        protected byte[] doInBackground(String ... tokens) {
            if (tokens.length != 1) {
                this.errorMsg = "Empty OAuth token.";
                return null;
            }
            try {
                String publicKey = Base64.encodeToString((byte[])BlessingActivity.this.mPublicKey.getEncoded(), (int)10);
                String token = tokens[0];
                String caveats = Base64.encodeToString((byte[])VomUtil.encode((Object)new Caveat[0], Caveat[].class), (int)10);
                String outputFormat = "base64vom";
                URL url = new URL("https://dev.v.io/auth/google/bless?token=" + token + "&public_key=" + publicKey + "&caveats=" + caveats + "&output_format=" + outputFormat);
                byte[] base64EncodedBlessingVom = ByteStreams.toByteArray((InputStream)url.openConnection().getInputStream());
                return Base64.decode((byte[])base64EncodedBlessingVom, (int)10);
            }
            catch (MalformedURLException e) {
                this.errorMsg = e.getMessage();
                return null;
            }
            catch (IOException e) {
                this.errorMsg = e.getMessage();
                return null;
            }
            catch (VException e) {
                this.errorMsg = e.getMessage();
                return null;
            }
        }

        protected void onPostExecute(byte[] blessingVom) {
            this.progressDialog.dismiss();
            if (blessingVom == null || blessingVom.length == 0) {
                BlessingActivity.this.replyWithError("Couldn't get identity from Vanadium identity servers: " + this.errorMsg);
                return;
            }
            BlessingActivity.this.replyWithSuccess(blessingVom);
        }
    }

    class OnTokenAcquired
    implements AccountManagerCallback<Bundle> {
        OnTokenAcquired() {
        }

        public void run(AccountManagerFuture<Bundle> result) {
            try {
                Bundle bundle = (Bundle)result.getResult();
                Intent launch = (Intent)bundle.get("intent");
                if (launch != null) {
                    launch.setFlags(0);
                    BlessingActivity.this.startActivityForResult(launch, 1000);
                    return;
                }
                String token = bundle.getString("authtoken");
                new BlessingFetcher().execute(new String[]{token});
            }
            catch (AuthenticatorException e) {
                BlessingActivity.this.replyWithError("Couldn't authorize: " + e.getMessage());
                return;
            }
            catch (OperationCanceledException e) {
                BlessingActivity.this.replyWithError("Authorization cancelled: " + e.getMessage());
                return;
            }
            catch (IOException e) {
                BlessingActivity.this.replyWithError("Unexpected error: " + e.getMessage());
                return;
            }
        }
    }
}

