/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.services.beam;

import android.util.Pair;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.android.impl.google.services.beam.IntentBeamerServer;
import io.v.android.v23.VBeam;
import io.v.v23.context.VContext;
import io.v.v23.rpc.ServerCall;
import io.v.v23.verror.VException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

class VBeamServer
implements IntentBeamerServer {
    private static final long EXPIRATION_MS = 60000L;
    private final Map<String, Long> requestMap = new LinkedHashMap<String, Long>();
    private final VBeam.IntentCreator callback;

    public VBeamServer(VBeam.IntentCreator creator) throws VException {
        this.callback = creator;
    }

    @Override
    public synchronized ListenableFuture<IntentBeamerServer.GetIntentOut> getIntent(VContext ctx, ServerCall call, String secret) {
        this.evictStaleRequests();
        if (this.requestMap.remove(secret) != null) {
            try {
                return Futures.transform(this.callback.createIntent(ctx, call), (AsyncFunction)new AsyncFunction<Pair<String, byte[]>, IntentBeamerServer.GetIntentOut>(){

                    public ListenableFuture<IntentBeamerServer.GetIntentOut> apply(Pair<String, byte[]> input) throws Exception {
                        return VBeamServer.convertIntent((Pair<String, byte[]>)input);
                    }
                });
            }
            catch (Throwable t) {
                return Futures.immediateFailedFuture((Throwable)t);
            }
        }
        return Futures.immediateFailedFuture((Throwable)new VException("Bad request"));
    }

    private static ListenableFuture<IntentBeamerServer.GetIntentOut> convertIntent(Pair<String, byte[]> intent) {
        IntentBeamerServer.GetIntentOut out = new IntentBeamerServer.GetIntentOut();
        out.intentUri = (String)intent.first;
        out.payload = (byte[])intent.second;
        return Futures.immediateFuture((Object)out);
    }

    private synchronized void evictStaleRequests() {
        long l;
        long now = System.currentTimeMillis();
        Iterator<Long> it = this.requestMap.values().iterator();
        while (it.hasNext() && ((l = it.next().longValue()) > now || l < now - 60000L)) {
            it.remove();
        }
    }

    synchronized String newRequest() {
        this.evictStaleRequests();
        String secret = UUID.randomUUID().toString();
        this.requestMap.put(secret, System.currentTimeMillis());
        return secret;
    }
}

