/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.services.beam;

import android.app.Activity;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.util.Log;
import io.v.android.impl.google.services.beam.VBeamServer;
import io.v.android.v23.VBeam;
import io.v.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.naming.Endpoint;
import io.v.v23.security.Authorizer;
import io.v.v23.security.VSecurity;
import io.v.v23.verror.VException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.interfaces.ECPublicKey;

public class VBeamManager
implements NfcAdapter.CreateNdefMessageCallback {
    static final String EXTERNAL_DOMAIN = "io.v.android.vbeam";
    static final String EXTERNAL_TYPE = "vbs";
    private static final String EXTERNAL_PATH = "/io.v.android.vbeam:vbs";
    private static final String TAG = "VBeamManager";
    private final VBeamServer server;
    private final VContext context;
    private final String packageName;
    public static final String EXTRA_VBEAM_PAYLOAD = "io.v.intent.vbeam.payload";

    public VBeamManager(VContext context, Activity activity, VBeam.IntentCreator creator) throws VException {
        this.server = new VBeamServer(creator);
        this.packageName = activity.getApplicationContext().getPackageName();
        this.context = V.withNewServer((VContext)context, (String)"", (Object)this.server, (Authorizer)VSecurity.newAllowEveryoneAuthorizer());
    }

    public NdefMessage createNdefMessage(NfcEvent event) {
        try {
            byte[] payload;
            String requestID = this.server.newRequest();
            try {
                Data data = new Data();
                data.secret = requestID;
                data.key = V.getPrincipal((VContext)this.context).publicKey();
                data.name = this.getEndpointName();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(data);
                oos.flush();
                payload = bos.toByteArray();
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"unable to encode ndef message", (Throwable)e);
                return null;
            }
            return new NdefMessage(new NdefRecord[]{NdefRecord.createExternal((String)EXTERNAL_DOMAIN, (String)EXTERNAL_TYPE, (byte[])payload), NdefRecord.createApplicationRecord((String)this.packageName)});
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"createNdefMessage failed", (Throwable)t);
            throw t;
        }
    }

    static Data decodeMessage(NdefMessage m) {
        for (NdefRecord r : m.getRecords()) {
            Uri uri = r.toUri();
            if (uri == null || !EXTERNAL_PATH.equals(uri.getPath())) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                StringBuilder description = new StringBuilder("ignoring ");
                if (uri == null) {
                    description.append(r);
                } else {
                    description.append(uri.getPath());
                    description.append(" != ");
                    description.append(EXTERNAL_PATH);
                }
                Log.d((String)TAG, (String)description.toString());
                continue;
            }
            byte[] payload = r.getPayload();
            if (payload == null) continue;
            ByteArrayInputStream bis = new ByteArrayInputStream(payload);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bis);
                Object d = ois.readObject();
                if (d == null || !(d instanceof Data)) continue;
                return (Data)d;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"decodeMessage", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"decodeMessage", (Throwable)e);
            }
        }
        return null;
    }

    private String getEndpointName() {
        Endpoint[] endpoints = V.getServer((VContext)this.context).getStatus().getEndpoints();
        return endpoints[0].name();
    }

    static class Data
    implements Serializable {
        String name;
        String secret;
        ECPublicKey key;

        Data() {
        }
    }
}

