/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.services.beam;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.nfc.NdefMessage;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.android.impl.google.services.beam.IntentBeamerClient;
import io.v.android.impl.google.services.beam.IntentBeamerClientFactory;
import io.v.android.impl.google.services.beam.VBeamManager;
import io.v.android.v23.V;
import io.v.v23.Options;
import io.v.v23.context.VContext;
import io.v.v23.security.VSecurity;
import java.security.interfaces.ECPublicKey;
import org.joda.time.Duration;

public class BeamActivity
extends Activity {
    private static final String TAG = "BeamActivity";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onResume() {
        NdefMessage m;
        Parcelable[] rawMsgs;
        super.onResume();
        NdefMessage[] msgs = null;
        Intent intent = this.getIntent();
        if ("android.nfc.action.NDEF_DISCOVERED".equals(intent.getAction()) && (rawMsgs = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES")) != null) {
            msgs = new NdefMessage[rawMsgs.length];
            for (int i = 0; i < rawMsgs.length; ++i) {
                msgs[i] = (NdefMessage)rawMsgs[i];
            }
        }
        if (msgs == null) {
            Log.d((String)TAG, (String)"No ndef messages");
            this.finish();
            return;
        }
        VBeamManager.Data data = null;
        NdefMessage[] i = msgs;
        int n = i.length;
        for (int j = 0; j < n && (data = VBeamManager.decodeMessage(m = i[j])) == null; ++j) {
        }
        if (data == null) {
            Log.w((String)TAG, (String)"Unable to deserialize data");
            this.finish();
            return;
        }
        Log.d((String)TAG, (String)("connecting to " + data.name));
        VContext ctx = V.init((Context)this).withTimeout(Duration.standardSeconds((long)2L));
        Options opts = new Options();
        opts.set("io.v.v23.SERVER_AUTHORIZER", (Object)VSecurity.newPublicKeyAuthorizer((ECPublicKey)data.key));
        IntentBeamerClient client = IntentBeamerClientFactory.getIntentBeamerClient(data.name);
        ListenableFuture<IntentBeamerClient.GetIntentOut> out = client.getIntent(ctx, data.secret, opts);
        Futures.addCallback(out, (FutureCallback)new FutureCallback<IntentBeamerClient.GetIntentOut>(){

            public void onSuccess(IntentBeamerClient.GetIntentOut result) {
                try {
                    Log.d((String)BeamActivity.TAG, (String)("got intent " + result.intentUri));
                    int flags = 0;
                    flags = result.intentUri.startsWith("intent:") ? 1 : 2;
                    Intent resultIntent = Intent.parseUri((String)result.intentUri, (int)flags);
                    resultIntent.putExtra("io.v.intent.vbeam.payload", result.payload);
                    BeamActivity.this.startActivity(resultIntent);
                    BeamActivity.this.finish();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
                BeamActivity.this.finish();
            }
        });
    }
}

