/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.rpc.protocols.bt;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.v.impl.google.rt.VRuntimeImpl;
import io.v.v23.context.VContext;
import io.v.v23.rpc.Callback;
import io.v.v23.verror.VException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.joda.time.Duration;

class Bluetooth {
    private static final List<Integer> BLUETOOTH_PORTS = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31);

    static Listener listen(VContext ctx, String btAddr) throws VException {
        String macAddr = Bluetooth.getMACAddress(btAddr);
        int port = Bluetooth.getPortNumber(btAddr);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (!macAddr.equals(adapter.getAddress())) {
            throw new VException("Illegal MAC address to listen on: no local device found with MAC address: " + macAddr + " (local address is: " + adapter.getAddress() + " )");
        }
        Object ports = null;
        if (port == 0) {
            ports = new ArrayList<Integer>(BLUETOOTH_PORTS);
            Collections.shuffle(ports);
        } else {
            ports = ImmutableList.of((Object)port);
        }
        Executor executor = VRuntimeImpl.getRuntimeExecutor((VContext)ctx);
        if (executor == null) {
            throw new VException("NULL executor in context: did you derive this context from the context returned by V.init()?");
        }
        VException lastError = null;
        Iterator iterator = ports.iterator();
        while (iterator.hasNext()) {
            int portNum = (Integer)iterator.next();
            try {
                BluetoothServerSocket socket = Bluetooth.listenOnPort(portNum);
                return new Listener(executor, socket, String.format("%s/%d", macAddr, portNum));
            }
            catch (VException e) {
                lastError = e;
            }
        }
        throw lastError;
    }

    static void dial(VContext ctx, String btAddr, final Duration timeout, final Callback<Stream> callback) throws VException {
        final String macAddr = Bluetooth.getMACAddress(btAddr);
        final int port = Bluetooth.getPortNumber(btAddr);
        final Executor executor = VRuntimeImpl.getRuntimeExecutor((VContext)ctx);
        if (executor == null) {
            throw new VException("NULL executor in context: did you derive this context from the context returned by V.init()?");
        }
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BluetoothDevice device = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(macAddr);
                try {
                    Method m = device.getClass().getMethod("createInsecureRfcommSocket", Integer.TYPE);
                    final BluetoothSocket socket = (BluetoothSocket)m.invoke((Object)device, port);
                    Timer timer = null;
                    if (timeout.getMillis() != 0L) {
                        timer = new Timer();
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    socket.close();
                                }
                                catch (IOException e) {
                                    System.err.println("Couldn't close BluetoothSocket.");
                                }
                            }
                        }, timeout.getMillis());
                    }
                    try {
                        socket.connect();
                    }
                    catch (IOException e) {
                        callback.onFailure(new VException("Couldn't connect: " + e.getMessage()));
                    }
                    finally {
                        if (timer != null) {
                            timer.cancel();
                        }
                    }
                    String localAddr = String.format("%s/%d", BluetoothAdapter.getDefaultAdapter().getAddress(), 0);
                    String remoteAddr = String.format("%s/%d", macAddr, port);
                    callback.onSuccess((Object)new Stream(executor, socket, localAddr, remoteAddr));
                }
                catch (Exception e) {
                    callback.onFailure(new VException("Couldn't invoke createInsecureRfcommSocket: " + e.getMessage()));
                }
            }
        });
    }

    private static BluetoothServerSocket listenOnPort(int port) throws VException {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        try {
            Method m = adapter.getClass().getMethod("listenUsingInsecureRfcommOn", Integer.TYPE);
            return (BluetoothServerSocket)m.invoke((Object)adapter, port);
        }
        catch (Exception e) {
            throw new VException("Error invoking listenUsingInsecureRfcommOn: " + e.getMessage());
        }
    }

    private static String getMACAddress(String btAddr) throws VException {
        List parts = Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)btAddr);
        switch (parts.size()) {
            case 0: {
                throw new VException(String.format("Couldn't split bluetooth address \"%s\" using \"/\" separator: got zero parts!", btAddr));
            }
            case 1: {
                return BluetoothAdapter.getDefaultAdapter().getAddress();
            }
            case 2: {
                String address = ((String)parts.get(0)).toUpperCase();
                if (!BluetoothAdapter.checkBluetoothAddress((String)address)) {
                    throw new VException("Invalid bluetooth address: " + btAddr);
                }
                return address;
            }
        }
        throw new VException(String.format("Couldn't parse bluetooth address \"%s\": too many \"/\".", btAddr));
    }

    private static int getPortNumber(String btAddr) throws VException {
        List parts = Splitter.on((String)"/").splitToList((CharSequence)btAddr);
        switch (parts.size()) {
            case 0: {
                throw new VException(String.format("Couldn't split bluetooth address \"%s\" using \"/\" separator: got zero parts!", btAddr));
            }
            case 1: 
            case 2: {
                try {
                    int port = Integer.parseInt((String)parts.get(parts.size() - 1));
                    if (port < 0 || port > 32) {
                        throw new VException(String.format("Illegal port number %q in bluetooth address \"%s\".", port, btAddr));
                    }
                    return port;
                }
                catch (NumberFormatException e) {
                    throw new VException(String.format("Couldn't parse port number in bluetooth address \"%s\": %s", btAddr, e.getMessage()));
                }
            }
        }
        throw new VException(String.format("Couldn't parse bluetooth address \"%s\": too many \"/\".", btAddr));
    }

    private Bluetooth() {
    }

    static class Stream {
        private final Executor executor;
        private final BluetoothSocket socket;
        private final String localAddress;
        private final String remoteAddress;

        Stream(Executor executor, BluetoothSocket socket, String localAddress, String remoteAddress) {
            this.executor = executor;
            this.socket = socket;
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
        }

        void read(final int n, final Callback<byte[]> callback) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] buf = new byte[n];
                        int num = Stream.this.socket.getInputStream().read(buf);
                        callback.onSuccess((Object)(num == buf.length ? buf : Arrays.copyOf(buf, num)));
                    }
                    catch (IOException e) {
                        callback.onFailure(new VException(e.getMessage()));
                    }
                }
            });
        }

        void write(final byte[] data, final Callback<Void> callback) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Stream.this.socket.getOutputStream().write(data);
                        callback.onSuccess(null);
                    }
                    catch (IOException e) {
                        callback.onFailure(new VException(e.getMessage()));
                    }
                }
            });
        }

        void close() throws IOException {
            this.socket.close();
        }

        String localAddress() {
            return this.localAddress;
        }

        String remoteAddress() {
            return this.remoteAddress;
        }
    }

    static class Listener {
        private final Executor executor;
        private final BluetoothServerSocket serverSocket;
        private final String localAddress;

        Listener(Executor executor, BluetoothServerSocket serverSocket, String address) {
            this.executor = executor;
            this.serverSocket = serverSocket;
            this.localAddress = address;
        }

        void accept(final Callback<Stream> callback) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BluetoothSocket socket = Listener.this.serverSocket.accept();
                        String remoteAddress = String.format("%s/%d", socket.getRemoteDevice().getAddress(), 0);
                        callback.onSuccess((Object)new Stream(Listener.this.executor, socket, Listener.this.localAddress, remoteAddress));
                    }
                    catch (IOException e) {
                        callback.onFailure(new VException(e.getMessage()));
                    }
                }
            });
        }

        void close() throws IOException {
            this.serverSocket.close();
        }

        String address() {
            return this.localAddress;
        }
    }
}

