/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.discovery.plugins.ble;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.v.impl.google.lib.discovery.Plugin;
import io.v.x.ref.lib.discovery.AdInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class DeviceCache {
    private static final Equivalence<AdInfo> ADINFO_EQUIVALENCE = new Equivalence<AdInfo>(){

        protected boolean doEquivalent(AdInfo a, AdInfo b) {
            return a.getAd().getId().equals((Object)b.getAd().getId()) && a.getHash().equals((Object)b.getHash());
        }

        protected int doHash(AdInfo adinfo) {
            return Objects.hashCode((Object[])new Object[]{adinfo.getAd().getId(), adinfo.getHash()});
        }
    };
    private static final Function<AdInfo, Equivalence.Wrapper<AdInfo>> ADINFO_WRAPPER = new Function<AdInfo, Equivalence.Wrapper<AdInfo>>(){

        public Equivalence.Wrapper<AdInfo> apply(AdInfo adinfo) {
            return ADINFO_EQUIVALENCE.wrap((Object)adinfo);
        }
    };
    private final Map<Long, CacheEntry> cacheByStamp = new HashMap<Long, CacheEntry>();
    private final Map<String, CacheEntry> cacheByDeviceId = new HashMap<String, CacheEntry>();
    private final SetMultimap<String, Equivalence.Wrapper<AdInfo>> adInfosByInterfaceName = HashMultimap.create();
    private final SetMultimap<String, Scanner> scannersByInterfaceName = HashMultimap.create();
    private final Map<Plugin.ScanHandler, Scanner> scannersByHandler = new HashMap<Plugin.ScanHandler, Scanner>();
    private final Duration maxAge;
    private ScheduledExecutorService timer;

    DeviceCache(Duration maxAge) {
        this.maxAge = maxAge;
        this.timer = Executors.newSingleThreadScheduledExecutor();
        long periodicity = maxAge.getMillis() / 2L;
        this.timer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DeviceCache.this.removeStaleEntries();
            }
        }, periodicity, periodicity, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleEntries() {
        DeviceCache deviceCache = this;
        synchronized (deviceCache) {
            Iterator<Map.Entry<Long, CacheEntry>> it = this.cacheByStamp.entrySet().iterator();
            while (it.hasNext()) {
                CacheEntry entry = it.next().getValue();
                if (!entry.lastSeen.plus((ReadableDuration)this.maxAge).isBeforeNow()) continue;
                it.remove();
                this.cacheByDeviceId.remove(entry.deviceId);
                for (Equivalence.Wrapper wrapper : entry.adInfos) {
                    AdInfo adinfo = (AdInfo)wrapper.get();
                    this.adInfosByInterfaceName.remove((Object)adinfo.getAd().getInterfaceName(), (Object)wrapper);
                    adinfo.setLost(true);
                    this.handleUpdate(adinfo);
                }
            }
        }
    }

    void shutdownCache() {
        this.timer.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean haveSeenStamp(long stamp, String deviceId) {
        DeviceCache deviceCache = this;
        synchronized (deviceCache) {
            CacheEntry entry = this.cacheByStamp.get(stamp);
            if (entry != null) {
                entry.lastSeen = new Instant();
                if (!entry.deviceId.equals(deviceId)) {
                    this.cacheByDeviceId.remove(entry.deviceId);
                    entry.deviceId = deviceId;
                    this.cacheByDeviceId.put(deviceId, entry);
                }
            }
            return entry != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDevice(long stamp, String deviceId, Iterable<AdInfo> adInfos) {
        ImmutableSet newAdInfos = FluentIterable.from(adInfos).transform(ADINFO_WRAPPER).toSet();
        CacheEntry entry = new CacheEntry(stamp, deviceId, (Set)newAdInfos);
        DeviceCache deviceCache = this;
        synchronized (deviceCache) {
            Object oldAdInfos;
            CacheEntry oldEntry = this.cacheByDeviceId.remove(deviceId);
            if (oldEntry != null) {
                this.cacheByStamp.remove(oldEntry.stamp);
                oldAdInfos = oldEntry.adInfos;
            } else {
                oldAdInfos = ImmutableSet.of();
            }
            Sets.SetView removed = Sets.difference((Set)oldAdInfos, (Set)newAdInfos);
            for (Equivalence.Wrapper wrapped : removed) {
                AdInfo adInfo = (AdInfo)wrapped.get();
                this.adInfosByInterfaceName.remove((Object)adInfo.getAd().getInterfaceName(), (Object)wrapped);
                adInfo.setLost(true);
                this.handleUpdate(adInfo);
            }
            Sets.SetView added = Sets.difference((Set)newAdInfos, (Set)oldAdInfos);
            for (Equivalence.Wrapper wrapped : added) {
                AdInfo adInfo = (AdInfo)wrapped.get();
                this.adInfosByInterfaceName.put((Object)adInfo.getAd().getInterfaceName(), (Object)wrapped);
                this.handleUpdate(adInfo);
            }
            this.cacheByStamp.put(stamp, entry);
            this.cacheByDeviceId.put(deviceId, entry);
        }
    }

    private void handleUpdate(AdInfo adinfo) {
        Set scanners = this.scannersByInterfaceName.get((Object)"");
        if (scanners != null) {
            for (Scanner scanner : scanners) {
                scanner.handler.handleUpdate(adinfo);
            }
        }
        if ((scanners = this.scannersByInterfaceName.get((Object)adinfo.getAd().getInterfaceName())) != null) {
            for (Scanner scanner : scanners) {
                scanner.handler.handleUpdate(adinfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addScanner(String interfaceName, Plugin.ScanHandler handler) {
        Scanner scanner = new Scanner(interfaceName, handler);
        DeviceCache deviceCache = this;
        synchronized (deviceCache) {
            this.scannersByHandler.put(handler, scanner);
            this.scannersByInterfaceName.put((Object)interfaceName, (Object)scanner);
            Collection adinfos = interfaceName.isEmpty() ? this.adInfosByInterfaceName.values() : this.adInfosByInterfaceName.get((Object)interfaceName);
            if (adinfos != null) {
                for (Equivalence.Wrapper wrapper : adinfos) {
                    scanner.handler.handleUpdate((AdInfo)wrapper.get());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeScanner(Plugin.ScanHandler handler) {
        DeviceCache deviceCache = this;
        synchronized (deviceCache) {
            Scanner scanner = this.scannersByHandler.remove(handler);
            if (scanner != null) {
                this.scannersByInterfaceName.remove((Object)scanner.interfaceName, (Object)scanner);
            }
        }
    }

    private static class CacheEntry {
        private final long stamp;
        private String deviceId;
        private Set<Equivalence.Wrapper<AdInfo>> adInfos;
        private Instant lastSeen;

        private CacheEntry(long stamp, String deviceId, Set<Equivalence.Wrapper<AdInfo>> adInfos) {
            this.stamp = stamp;
            this.deviceId = deviceId;
            this.adInfos = adInfos;
            this.lastSeen = new Instant();
        }
    }

    private static class Scanner {
        private final String interfaceName;
        private final Plugin.ScanHandler handler;

        private Scanner(String interfaceName, Plugin.ScanHandler handler) {
            this.interfaceName = interfaceName;
            this.handler = handler;
        }
    }
}

