/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.discovery.plugins.ble;

import com.google.common.primitives.Bytes;
import io.v.impl.google.lib.discovery.EncodingUtil;
import io.v.impl.google.lib.discovery.UUIDUtil;
import io.v.v23.discovery.AdId;
import io.v.v23.discovery.Advertisement;
import io.v.v23.discovery.Attachments;
import io.v.v23.discovery.Attributes;
import io.v.x.ref.lib.discovery.AdHash;
import io.v.x.ref.lib.discovery.AdInfo;
import io.v.x.ref.lib.discovery.Constants;
import io.v.x.ref.lib.discovery.EncryptionAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

class ConvertUtil {
    private static final Logger logger = Logger.getLogger(ConvertUtil.class.getName());
    private static final Charset ENC = Charset.forName("ISO8859-1");
    private static final UUID UUID_ID = UUID.fromString("bf0a3657-37cb-5aad-8c13-00c1d69a141c");
    private static final UUID UUID_INTERFACE_NAME = UUID.fromString("b2cadfd4-d003-576c-acad-58b8e3a9cbc8");
    private static final UUID UUID_ADDRESSES = UUID.fromString("fe3fa941-1eda-5265-806f-d5127794a9a9");
    private static final UUID UUID_ENCRYPTION = UUID.fromString("6286d80a-adaa-519a-8a06-281a4645a607");
    private static final UUID UUID_HASH = UUID.fromString("9c6286f5-aab0-5009-b81b-704d57ed6035");
    private static final UUID UUID_DIR_ADDRS = UUID.fromString("7d8b5c56-0d05-5a7a-a21e-6c0c3c31245e");

    ConvertUtil() {
    }

    static Map<UUID, byte[]> toGattAttrs(AdInfo adinfo) throws IOException {
        List list;
        Attachments attachments;
        HashMap<UUID, byte[]> gatt = new HashMap<UUID, byte[]>();
        Advertisement ad = adinfo.getAd();
        gatt.put(UUID_ID, ad.getId().toPrimitiveArray());
        gatt.put(UUID_INTERFACE_NAME, ad.getInterfaceName().getBytes(ENC));
        gatt.put(UUID_ADDRESSES, EncodingUtil.packAddresses((List)ad.getAddresses()));
        Attributes attributes = ad.getAttributes();
        if (attributes != null && attributes.size() > 0) {
            for (Map.Entry entry : attributes.entrySet()) {
                String string = (String)entry.getKey();
                String data = string + "=" + (String)entry.getValue();
                gatt.put(UUIDUtil.attributeUUID((String)string), data.getBytes(ENC));
            }
        }
        if ((attachments = ad.getAttachments()) != null && attachments.size() > 0) {
            for (Map.Entry entry : attachments.entrySet()) {
                String key = "__" + (String)entry.getKey();
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                buf.write(key.getBytes(ENC));
                buf.write(61);
                buf.write((byte[])entry.getValue());
                gatt.put(UUIDUtil.attributeUUID((String)key), buf.toByteArray());
            }
        }
        if (adinfo.getEncryptionAlgorithm() != Constants.NO_ENCRYPTION) {
            gatt.put(UUID_ENCRYPTION, EncodingUtil.packEncryptionKeys((EncryptionAlgorithm)adinfo.getEncryptionAlgorithm(), (List)adinfo.getEncryptionKeys()));
        }
        if ((list = adinfo.getDirAddrs()) != null && !list.isEmpty()) {
            gatt.put(UUID_DIR_ADDRS, EncodingUtil.packAddresses((List)list));
        }
        gatt.put(UUID_HASH, adinfo.getHash().toPrimitiveArray());
        return gatt;
    }

    static AdInfo toAdInfo(Map<UUID, byte[]> attrs) throws IOException {
        AdInfo adinfo = new AdInfo();
        Advertisement ad = adinfo.getAd();
        for (Map.Entry<UUID, byte[]> entry : attrs.entrySet()) {
            Object value;
            UUID uuid = entry.getKey();
            byte[] data = entry.getValue();
            if (uuid.equals(UUID_ID)) {
                ad.setId(new AdId(data));
                continue;
            }
            if (uuid.equals(UUID_INTERFACE_NAME)) {
                ad.setInterfaceName(new String(data, ENC));
                continue;
            }
            if (uuid.equals(UUID_ADDRESSES)) {
                ad.setAddresses(EncodingUtil.unpackAddresses((byte[])data));
                continue;
            }
            if (uuid.equals(UUID_ENCRYPTION)) {
                ArrayList keys = new ArrayList();
                EncryptionAlgorithm algo = EncodingUtil.unpackEncryptionKeys((byte[])data, keys);
                adinfo.setEncryptionAlgorithm(algo);
                adinfo.setEncryptionKeys(keys);
                continue;
            }
            if (uuid.equals(UUID_DIR_ADDRS)) {
                adinfo.setDirAddrs(EncodingUtil.unpackAddresses((byte[])data));
                continue;
            }
            if (uuid.equals(UUID_HASH)) {
                adinfo.setHash(new AdHash(data));
                continue;
            }
            int index = Bytes.indexOf((byte[])data, (byte)61);
            if (index < 0) {
                logger.severe("Failed to parse data for " + uuid);
                continue;
            }
            String key = new String(data, 0, index, ENC);
            if (key.startsWith("__")) {
                key = key.substring("__".length());
                value = Arrays.copyOfRange(data, index + 1, data.length);
                ad.getAttachments().put((Object)key, value);
                continue;
            }
            value = new String(data, index + 1, data.length - index - 1, ENC);
            ad.getAttributes().put((Object)key, value);
        }
        return adinfo;
    }
}

