/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.discovery.plugins.ble;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class BluetoothGattReader
extends BluetoothGattCallback {
    private static final String TAG = "BluetoothGattClientCallback";
    static final String GATT_AND_GAP_PREFIX = "0000180";
    private final Handler handler;
    private final Map<UUID, Map<UUID, byte[]>> services = new HashMap<UUID, Map<UUID, byte[]>>();
    private BluetoothGatt gatt;
    private final List<BluetoothGattCharacteristic> characteristics = new ArrayList<BluetoothGattCharacteristic>();
    private int characteristicsIndex;

    BluetoothGattReader(Handler handler) {
        this.handler = handler;
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        for (BluetoothGattService service : gatt.getServices()) {
            Log.d((String)TAG, (String)("found service" + service.getUuid().toString()));
            if (service.getUuid().toString().startsWith(GATT_AND_GAP_PREFIX)) continue;
            this.services.put(service.getUuid(), new HashMap());
            for (BluetoothGattCharacteristic c : service.getCharacteristics()) {
                if ((c.getProperties() & 2) != 0) {
                    this.characteristics.add(c);
                    continue;
                }
                Log.d((String)TAG, (String)"skipping non read property");
            }
        }
        this.characteristicsIndex = 0;
        this.maybeReadNextCharacteristic();
    }

    private void maybeReadNextCharacteristic() {
        BluetoothGattCharacteristic c;
        if (this.characteristicsIndex >= this.characteristics.size()) {
            this.gatt.disconnect();
            this.gatt.close();
            this.handler.handle(this.services);
            return;
        }
        if (!this.gatt.readCharacteristic(c = this.characteristics.get(this.characteristicsIndex++))) {
            Log.w((String)TAG, (String)("failed to read characteristic " + c.getUuid()));
            this.maybeReadNextCharacteristic();
        }
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic c, int status) {
        UUID serviceUuid = c.getService().getUuid();
        Log.d((String)TAG, (String)("got characteristic [" + serviceUuid + "]" + c.getUuid() + "=" + c.getValue()));
        this.services.get(serviceUuid).put(c.getUuid(), c.getValue());
        this.maybeReadNextCharacteristic();
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        Log.d((String)TAG, (String)("new connections state is " + newState));
        this.gatt = gatt;
        if (status != 0 || newState != 2) {
            Log.w((String)TAG, (String)("failed to connect with status " + status + " state" + newState));
            gatt.close();
            this.handler.handle(null);
            return;
        }
        gatt.discoverServices();
    }

    static interface Handler {
        public void handle(Map<UUID, Map<UUID, byte[]>> var1);
    }
}

